/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.module.worldportals.common.portal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.ichun.mods.ichunutil.client.render.RendererHelper;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.ichunutil.common.entity.EntityBlock;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.module.worldportals.common.WorldPortals;
import me.ichun.mods.ichunutil.common.module.worldportals.common.packet.PacketEntityLocation;
import me.ichun.mods.ichunutil.common.module.worldportals.common.portal.EntityTransformationStack;
import me.ichun.mods.ichunutil.common.module.worldportals.common.portal.QuaternionFormula;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRain;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class WorldPortal {
    private EnumFacing faceOn;
    private EnumFacing upDir;
    private QuaternionFormula quaternionFormula;
    private AxisAlignedBB plane;
    private AxisAlignedBB flatPlane;
    public AxisAlignedBB scanRange;
    public AxisAlignedBB portalInsides;
    private float width;
    private float height;
    private Vec3d position;
    private BlockPos posBlock;
    private HashSet<AxisAlignedBB> collisions;
    private WorldPortal pair;
    public World world;
    public int time;
    public List<Entity> lastScanEntities = new ArrayList<Entity>();
    public HashMap<Entity, Integer> teleportCooldown = new HashMap();
    private boolean firstUpdate;
    public boolean renderAll = false;

    public WorldPortal(World world) {
        this.world = world;
        this.position = new Vec3d(0.0, 0.0, 0.0);
        this.posBlock = new BlockPos(this.position);
        this.faceOn = EnumFacing.NORTH;
        this.upDir = EnumFacing.UP;
        this.time = 0;
        this.firstUpdate = true;
    }

    public WorldPortal(World world, Vec3d position, EnumFacing faceOn, EnumFacing upDir, float width, float height) {
        this.world = world;
        this.position = position;
        this.posBlock = new BlockPos(this.position);
        this.faceOn = faceOn;
        this.upDir = upDir;
        this.width = width;
        this.height = height;
        this.setupAABBs();
        this.time = 0;
        this.firstUpdate = true;
    }

    public abstract float getPlaneOffset();

    public abstract boolean canCollideWithBorders();

    public abstract String owner();

    @SideOnly(value=Side.CLIENT)
    public abstract void drawPlane(float var1);

    public void setFace(EnumFacing faceOut, EnumFacing upDir) {
        this.faceOn = faceOut;
        this.upDir = upDir;
        this.setupAABBs();
    }

    public EnumFacing getFaceOn() {
        return this.faceOn;
    }

    public EnumFacing getUpDir() {
        return this.upDir;
    }

    public BlockPos getPos() {
        return this.posBlock;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setSize(float width, float height) {
        this.width = width;
        this.height = height;
        this.setupAABBs();
    }

    public float getScanDistance() {
        return 3.0f;
    }

    public void updateWorldPortal() {
        if (this.firstUpdate) {
            this.firstUpdate = false;
        }
        ++this.time;
        if (!this.canTeleportEntities()) {
            return;
        }
        Iterator<Map.Entry<Entity, Integer>> ite = this.teleportCooldown.entrySet().iterator();
        while (ite.hasNext()) {
            Map.Entry<Entity, Integer> e = ite.next();
            e.setValue(e.getValue() - 1);
            if (e.getValue() >= 0) continue;
            WorldPortals.eventHandler.removeMonitoredEntity(e.getKey(), this);
            ite.remove();
        }
        if (!this.hasPair()) {
            return;
        }
        EnumFacing faceOn = this.getFaceOn();
        List entitiesInRange = this.world.func_72872_a(Entity.class, this.scanRange);
        for (int i = entitiesInRange.size() - 1; i >= 0; --i) {
            Entity ent = (Entity)entitiesInRange.get(i);
            if (this.isAgainstWall()) {
                WorldPortals.eventHandler.addMonitoredEntity(ent, this);
            }
            if (!this.canEntityTeleport(ent)) {
                entitiesInRange.remove(i);
                continue;
            }
            if (this.teleportCooldown.containsKey(ent) || ent instanceof EntityPlayerMP && !ent.func_130014_f_().field_72995_K) continue;
            double[] motions = EntityHelper.simulateMoveEntity(ent, ent.field_70159_w, ent.field_70181_x, ent.field_70179_y);
            Vec3d newEntPos = new Vec3d(ent.field_70165_t + motions[0], ent.field_70163_u + (double)ent.func_70047_e() + motions[1], ent.field_70161_v + motions[2]);
            boolean teleport = false;
            AxisAlignedBB teleportPlane = this.flatPlane;
            float offset = 0.0f;
            if (this.isAgainstWall() && ent instanceof EntityPlayer) {
                offset = Math.min(0.05f, (float)Math.abs((this.flatPlane.field_72340_a - ent.field_70165_t) * (double)faceOn.func_82601_c() + (this.flatPlane.field_72338_b - ent.field_70163_u) * (double)faceOn.func_96559_d() + (this.flatPlane.field_72339_c - ent.field_70161_v) * (double)faceOn.func_82599_e()));
                if (!this.scanRange.func_72317_d((double)((float)faceOn.func_82601_c() * offset), (double)((float)faceOn.func_96559_d() * offset), (double)((float)faceOn.func_82599_e() * offset)).func_72318_a(newEntPos) && this.portalInsides.func_72317_d((double)((float)faceOn.func_82601_c() * offset), (double)((float)faceOn.func_96559_d() * offset), (double)((float)faceOn.func_82599_e() * offset)).func_72318_a(newEntPos) && (faceOn.func_176740_k().func_176722_c() && ent.func_174813_aQ().field_72338_b >= this.flatPlane.field_72338_b && ent.func_174813_aQ().field_72337_e <= this.flatPlane.field_72337_e || faceOn.func_176740_k().func_176720_b() && ent.func_174813_aQ().field_72340_a >= this.flatPlane.field_72340_a && ent.func_174813_aQ().field_72336_d <= this.flatPlane.field_72336_d && ent.func_174813_aQ().field_72339_c >= this.flatPlane.field_72339_c && ent.func_174813_aQ().field_72334_f <= this.flatPlane.field_72334_f)) {
                    teleportPlane = this.getTeleportPlane(offset);
                    teleport = true;
                }
            } else if (!this.scanRange.func_72318_a(newEntPos) && this.portalInsides.func_72318_a(newEntPos)) {
                teleport = true;
            }
            if (!teleport) continue;
            double centerX = (teleportPlane.field_72336_d + teleportPlane.field_72340_a) / 2.0;
            double centerY = (teleportPlane.field_72337_e + teleportPlane.field_72338_b) / 2.0;
            double centerZ = (teleportPlane.field_72334_f + teleportPlane.field_72339_c) / 2.0;
            if (this.pair == null) continue;
            float[] appliedOffset = this.getQuaternionFormula().applyPositionalRotation(new float[]{(float)(newEntPos.field_72450_a - centerX), (float)(newEntPos.field_72448_b - centerY), (float)(newEntPos.field_72449_c - centerZ)});
            float[] appliedMotion = this.getQuaternionFormula().applyPositionalRotation(new float[]{(float)motions[0], (float)motions[1], (float)motions[2]});
            float[] appliedRotation = this.getQuaternionFormula().applyRotationalRotation(new float[]{ent.field_70177_z, ent.field_70125_A, ent.func_130014_f_().field_72995_K ? this.getRoll(ent) : 0.0f});
            AxisAlignedBB pairTeleportPlane = this.pair.getTeleportPlane(offset);
            double destX = (pairTeleportPlane.field_72336_d + pairTeleportPlane.field_72340_a) / 2.0;
            double destY = (pairTeleportPlane.field_72337_e + pairTeleportPlane.field_72338_b) / 2.0;
            double destZ = (pairTeleportPlane.field_72334_f + pairTeleportPlane.field_72339_c) / 2.0;
            EntityTransformationStack ets = new EntityTransformationStack(ent);
            ets.translate(destX - ent.field_70165_t + (double)appliedOffset[0], destY - (ent.field_70163_u + (double)ent.func_70047_e()) + (double)appliedOffset[1], destZ - ent.field_70161_v + (double)appliedOffset[2]);
            ets.rotate(appliedRotation[0], appliedRotation[1], appliedRotation[2]);
            ent.func_70107_b(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
            double maxWidthHeight = Math.max(ent.field_70130_N, ent.field_70131_O);
            EntityHelper.putEntityWithinAABB(ent, this.pair.scanRange.func_72321_a((double)this.pair.getFaceOn().func_82601_c() * -maxWidthHeight, (double)this.pair.getFaceOn().func_96559_d() * -maxWidthHeight, (double)this.pair.getFaceOn().func_82599_e() * -maxWidthHeight));
            ent.field_70159_w = appliedMotion[0];
            ent.field_70181_x = appliedMotion[1];
            ent.field_70179_y = appliedMotion[2];
            if (Math.abs(ent.field_70159_w) > 0.99) {
                ent.field_70159_w /= Math.abs(ent.field_70159_w) + 0.001;
            }
            if (Math.abs(ent.field_70181_x) > 0.99) {
                ent.field_70181_x /= Math.abs(ent.field_70181_x) + 0.001;
            }
            if (Math.abs(ent.field_70179_y) > 0.99) {
                ent.field_70179_y /= Math.abs(ent.field_70179_y) + 0.001;
            }
            ent.field_70143_R = 0.1f * ((float)ent.field_70181_x / -0.1f * (float)ent.field_70181_x / -0.1f);
            ent.func_70107_b(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
            this.pair.teleportCooldown.put(ent, 3);
            this.pair.lastScanEntities.add(ent);
            if (this.pair.isAgainstWall()) {
                WorldPortals.eventHandler.addMonitoredEntity(ent, this.pair);
            }
            this.teleportCooldown.put(ent, 3);
            this.lastScanEntities.remove(ent);
            this.handleSpecialEntities(ent);
            if (ent.func_130014_f_().field_72995_K) {
                this.handleClientEntityTeleport(ent, appliedRotation);
                continue;
            }
            WorldPortals.channel.sendToAllAround(new PacketEntityLocation(ent), new NetworkRegistry.TargetPoint(ent.field_71093_bK, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, 256.0));
        }
        if (this.world.field_72995_K) {
            this.handleClient();
        }
        if (this.isAgainstWall()) {
            this.lastScanEntities.removeAll(entitiesInRange);
            for (Entity ent : this.lastScanEntities) {
                if (this.teleportCooldown.containsKey(ent)) continue;
                WorldPortals.eventHandler.removeMonitoredEntity(ent, this);
            }
            this.lastScanEntities = entitiesInRange;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getRoll(Entity ent) {
        if (ent == Minecraft.func_71410_x().func_175606_aa()) {
            return WorldPortals.eventHandlerClient.cameraRoll;
        }
        return 0.0f;
    }

    public boolean canEntityTeleport(Entity ent) {
        return true;
    }

    public void handleSpecialEntities(Entity ent) {
        if (ent instanceof EntityBlock) {
            ((EntityBlock)ent).timeExisting = 2;
        } else if (ent instanceof EntityFallingBlock) {
            ((EntityFallingBlock)ent).field_145812_b = 2;
        } else if (ent instanceof EntityFireball) {
            EntityFireball fireball = (EntityFireball)ent;
            float[] appliedAcceleration = this.getQuaternionFormula().applyPositionalRotation(new float[]{(float)fireball.field_70232_b, (float)fireball.field_70233_c, (float)fireball.field_70230_d});
            fireball.field_70232_b = appliedAcceleration[0];
            fireball.field_70233_c = appliedAcceleration[1];
            fireball.field_70230_d = appliedAcceleration[2];
        } else if (ent instanceof EntityArrow) {
            ((EntityArrow)ent).field_70254_i = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient() {
        Minecraft mc = Minecraft.func_71410_x();
        EnumFacing faceOn = this.getFaceOn();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (Particle particle : mc.field_71452_i.field_78876_b[i][j]) {
                    boolean isRain;
                    Vec3d particlePos = new Vec3d(particle.field_187123_c, particle.field_187124_d, particle.field_187125_e);
                    Vec3d newParticlePos = new Vec3d(particle.field_187126_f, particle.field_187127_g, particle.field_187128_h);
                    float offset = (float)Math.abs((particle.field_187123_c - particle.field_187126_f) * (double)faceOn.func_82601_c() * 1.5 + (particle.field_187124_d - particle.field_187127_g) * (double)faceOn.func_96559_d() * 1.5 + (particle.field_187125_e - particle.field_187128_h) * (double)faceOn.func_82599_e() * 1.5);
                    boolean bl = isRain = particle instanceof ParticleRain && faceOn == EnumFacing.UP && this.scanRange.func_72318_a(particlePos);
                    if (!isRain && (this.portalInsides.func_72317_d((double)((float)faceOn.func_82601_c() * offset), (double)((float)faceOn.func_96559_d() * offset), (double)((float)faceOn.func_82599_e() * offset)).func_72326_a(particle.func_187116_l()) || !this.portalInsides.func_72317_d((double)((float)faceOn.func_82601_c() * offset), (double)((float)faceOn.func_96559_d() * offset), (double)((float)faceOn.func_82599_e() * offset)).func_72326_a(particle.func_187116_l().func_72317_d(particle.field_187129_i, particle.field_187130_j, particle.field_187131_k)))) continue;
                    AxisAlignedBB teleportPlane = this.getTeleportPlane(offset);
                    double centerX = (teleportPlane.field_72336_d + teleportPlane.field_72340_a) / 2.0;
                    double centerY = (teleportPlane.field_72337_e + teleportPlane.field_72338_b) / 2.0;
                    double centerZ = (teleportPlane.field_72334_f + teleportPlane.field_72339_c) / 2.0;
                    if (this.pair == null) continue;
                    float[] appliedOffset = this.getQuaternionFormula().applyPositionalRotation(new float[]{(float)(newParticlePos.field_72450_a - centerX), (float)(newParticlePos.field_72448_b - centerY), (float)(newParticlePos.field_72449_c - centerZ)});
                    float[] appliedMotion = this.getQuaternionFormula().applyPositionalRotation(new float[]{(float)(newParticlePos.field_72450_a - particlePos.field_72450_a), (float)(newParticlePos.field_72448_b - particlePos.field_72448_b), (float)(newParticlePos.field_72449_c - particlePos.field_72449_c)});
                    AxisAlignedBB pairTeleportPlane = this.pair.getTeleportPlane(offset);
                    double destX = (pairTeleportPlane.field_72336_d + pairTeleportPlane.field_72340_a) / 2.0;
                    double destY = (pairTeleportPlane.field_72337_e + pairTeleportPlane.field_72338_b) / 2.0;
                    double destZ = (pairTeleportPlane.field_72334_f + pairTeleportPlane.field_72339_c) / 2.0;
                    double x = destX - particle.field_187126_f + (double)appliedOffset[0];
                    double y = destY - particle.field_187127_g + (double)appliedOffset[1];
                    double z = destZ - particle.field_187128_h + (double)appliedOffset[2];
                    particle.field_187126_f += x;
                    particle.field_187127_g += y;
                    particle.field_187128_h += z;
                    particle.field_187123_c += x;
                    particle.field_187124_d += y;
                    particle.field_187125_e += z;
                    particle.func_187109_b(particle.field_187126_f, particle.field_187127_g, particle.field_187128_h);
                    particle.field_187129_i = appliedMotion[0];
                    particle.field_187130_j = appliedMotion[1];
                    particle.field_187131_k = appliedMotion[2];
                    if (!isRain) continue;
                    particle.field_187129_i *= 5.0;
                    particle.field_187130_j *= 5.0;
                    particle.field_187131_k *= 5.0;
                }
            }
        }
    }

    public void terminate() {
        if (this.isAgainstWall()) {
            for (Entity ent : this.lastScanEntities) {
                if (ent.func_174813_aQ().func_72326_a(this.portalInsides)) {
                    EnumFacing faceOn = this.getFaceOn();
                    EntityHelper.putEntityWithinAABB(ent, this.flatPlane.func_72317_d((double)faceOn.func_82601_c() * 0.5, (double)faceOn.func_96559_d() * 0.5, (double)faceOn.func_82599_e() * 0.5));
                    ent.func_70107_b(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
                }
                WorldPortals.eventHandler.removeMonitoredEntity(ent, this);
            }
        }
        if (this.hasPair()) {
            this.pair.setPair(null);
            this.setPair(null);
        }
    }

    public boolean isValid() {
        return !this.firstUpdate;
    }

    public boolean isFirstUpdate() {
        return this.firstUpdate;
    }

    public void forceFirstUpdate() {
        this.firstUpdate = true;
    }

    public boolean isAgainstWall() {
        return false;
    }

    private AxisAlignedBB createPlaneAround(double size) {
        return this.createPlaneAround(this.getPosition(), size);
    }

    private AxisAlignedBB createPlaneAround(Vec3d pos, double size) {
        double halfW = (double)this.width / 2.0;
        double halfH = (double)this.height / 2.0;
        AxisAlignedBB plane = new AxisAlignedBB(pos.field_72450_a - halfW, pos.field_72448_b - halfH, pos.field_72449_c - size, pos.field_72450_a + halfW, pos.field_72448_b + halfH, pos.field_72449_c + size);
        EnumFacing faceOn = this.getFaceOn();
        if (faceOn.func_176740_k() == EnumFacing.Axis.Y) {
            plane = EntityHelper.rotateAABB(EnumFacing.Axis.X, plane, faceOn == EnumFacing.UP ? -90.0 : 90.0, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }
        plane = EntityHelper.rotateAABB(EnumFacing.Axis.Y, plane, faceOn.func_176740_k() == EnumFacing.Axis.X ? 90.0 : (faceOn.func_176740_k() == EnumFacing.Axis.Y && this.getUpDir().func_176740_k() == EnumFacing.Axis.X ? 90.0 : 0.0), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c).func_72317_d((double)((float)faceOn.func_82601_c() * this.getPlaneOffset()), (double)((float)faceOn.func_96559_d() * this.getPlaneOffset()), (double)((float)faceOn.func_82599_e() * this.getPlaneOffset()));
        return plane;
    }

    public AxisAlignedBB getCollisionRemovalAabbForEntity(Entity ent) {
        double max = Math.max((double)Math.max(ent.field_70130_N, ent.field_70131_O) + Math.sqrt(ent.field_70159_w * ent.field_70159_w + ent.field_70181_x * ent.field_70181_x + ent.field_70179_y * ent.field_70179_y), 1.0);
        EnumFacing faceOn = this.getFaceOn();
        return this.flatPlane.func_72321_a((double)faceOn.func_82601_c() * -max, (double)faceOn.func_96559_d() * -max, (double)faceOn.func_82599_e() * -max);
    }

    public AxisAlignedBB getPortalInsides(Entity ent) {
        if (this.isAgainstWall() && ent instanceof EntityPlayer) {
            EnumFacing faceOn = this.getFaceOn();
            float offset = Math.min(0.05f, (float)Math.abs((this.flatPlane.field_72340_a - ent.field_70165_t) * (double)faceOn.func_82601_c() + (this.flatPlane.field_72338_b - ent.field_70163_u) * (double)faceOn.func_96559_d() + (this.flatPlane.field_72339_c - ent.field_70161_v) * (double)faceOn.func_82599_e()));
            return this.portalInsides.func_72317_d((double)((float)faceOn.func_82601_c() * offset), (double)((float)faceOn.func_96559_d() * offset), (double)((float)faceOn.func_82599_e() * offset));
        }
        return this.portalInsides;
    }

    public AxisAlignedBB getPlane() {
        return this.plane;
    }

    private void setupAABBs() {
        EnumFacing faceOn = this.getFaceOn();
        this.plane = this.createPlaneAround(0.0125);
        this.flatPlane = this.createPlaneAround(0.0);
        this.scanRange = this.flatPlane.func_72321_a((double)((float)faceOn.func_82601_c() * this.getScanDistance()), (double)((float)faceOn.func_96559_d() * this.getScanDistance()), (double)((float)faceOn.func_82599_e() * this.getScanDistance()));
        this.portalInsides = this.flatPlane.func_72321_a((double)faceOn.func_82601_c() * -100.0, (double)faceOn.func_96559_d() * -100.0, (double)faceOn.func_82599_e() * -100.0);
    }

    public AxisAlignedBB getFlatPlane() {
        return this.flatPlane;
    }

    public AxisAlignedBB getTeleportPlane(float offset) {
        if (offset != 0.0f) {
            EnumFacing faceOn = this.getFaceOn();
            return this.flatPlane.func_72317_d((double)((float)faceOn.func_82601_c() * offset), (double)((float)faceOn.func_96559_d() * offset), (double)((float)faceOn.func_82599_e() * offset));
        }
        return this.flatPlane;
    }

    public boolean getCullRender() {
        return !this.renderAll;
    }

    public void setCullRender(boolean flag) {
        this.renderAll = !flag;
    }

    public boolean canTeleportEntities() {
        return true;
    }

    public HashSet<AxisAlignedBB> getCollisionBoundaries() {
        if (this.collisions == null) {
            this.collisions = new HashSet(4);
            if (this.canCollideWithBorders()) {
                double size = 0.0125;
                AxisAlignedBB plane = this.flatPlane;
                if (plane.field_72336_d - plane.field_72340_a > size * 3.0) {
                    this.collisions.add(new AxisAlignedBB(plane.field_72336_d, plane.field_72338_b, plane.field_72339_c, plane.field_72336_d + size, plane.field_72337_e, plane.field_72334_f));
                    this.collisions.add(new AxisAlignedBB(plane.field_72340_a - size, plane.field_72338_b, plane.field_72339_c, plane.field_72340_a, plane.field_72337_e, plane.field_72334_f));
                }
                if (plane.field_72337_e - plane.field_72338_b > size * 3.0) {
                    this.collisions.add(new AxisAlignedBB(plane.field_72340_a, plane.field_72337_e, plane.field_72339_c, plane.field_72336_d, plane.field_72337_e + size, plane.field_72334_f));
                    this.collisions.add(new AxisAlignedBB(plane.field_72340_a, plane.field_72338_b - size, plane.field_72339_c, plane.field_72336_d, plane.field_72338_b, plane.field_72334_f));
                }
                if (plane.field_72334_f - plane.field_72339_c > size * 3.0) {
                    this.collisions.add(new AxisAlignedBB(plane.field_72340_a, plane.field_72338_b, plane.field_72334_f, plane.field_72336_d, plane.field_72337_e, plane.field_72334_f + size));
                    this.collisions.add(new AxisAlignedBB(plane.field_72340_a, plane.field_72338_b, plane.field_72339_c - size, plane.field_72336_d, plane.field_72337_e, plane.field_72339_c));
                }
            }
        }
        return this.collisions;
    }

    public boolean hasPair() {
        return this.pair != null && this.pair.position.field_72448_b > 0.0;
    }

    public void setPair(WorldPortal portal) {
        if (this.pair != portal) {
            this.pair = portal;
            if (this.pair != null) {
                this.quaternionFormula = QuaternionFormula.createFromPlanes(this.getFaceOn(), this.getUpDir(), this.pair.getFaceOn(), this.pair.getUpDir());
            }
        }
    }

    public WorldPortal getPair() {
        return this.pair;
    }

    public void setPosition(Vec3d v) {
        this.position = v;
        this.posBlock = new BlockPos(v);
        this.setupAABBs();
    }

    public Vec3d getPosition() {
        return this.position;
    }

    public QuaternionFormula getQuaternionFormula() {
        return this.pair != null ? this.quaternionFormula : QuaternionFormula.NO_ROTATION;
    }

    public NBTTagCompound write(NBTTagCompound tag) {
        return this.writePair(this.writeSelf(tag));
    }

    public NBTTagCompound writeSelf(NBTTagCompound tag) {
        tag.func_74776_a("width", this.width);
        tag.func_74776_a("height", this.height);
        tag.func_74768_a("faceOn", this.faceOn.func_176745_a());
        tag.func_74768_a("up", this.upDir.func_176745_a());
        tag.func_74780_a("posX", this.position.field_72450_a);
        tag.func_74780_a("posY", this.position.field_72448_b);
        tag.func_74780_a("posZ", this.position.field_72449_c);
        tag.func_74768_a("time", this.time);
        return tag;
    }

    public NBTTagCompound writePair(NBTTagCompound tag) {
        if (this.hasPair()) {
            tag.func_74782_a("pair", (NBTBase)this.pair.writeSelf(new NBTTagCompound()));
        }
        return tag;
    }

    public void read(NBTTagCompound tag) {
        this.readSelf(tag);
        this.readPair(tag);
    }

    public void readSelf(NBTTagCompound tag) {
        this.setSize(tag.func_74760_g("width"), tag.func_74760_g("height"));
        this.setFace(EnumFacing.func_82600_a((int)tag.func_74762_e("faceOn")), EnumFacing.func_82600_a((int)tag.func_74762_e("up")));
        this.setPosition(new Vec3d(tag.func_74769_h("posX"), tag.func_74769_h("posY"), tag.func_74769_h("posZ")));
        this.time = tag.func_74762_e("time");
        this.firstUpdate = true;
    }

    public void readPair(NBTTagCompound tag) {
        if (tag.func_74764_b("pair")) {
            this.setPair((WorldPortal)this.createFakeInstance(tag.func_74775_l("pair")));
        }
    }

    public abstract <T extends WorldPortal> T createFakeInstance(NBTTagCompound var1);

    @SideOnly(value=Side.CLIENT)
    public void handleClientEntityTeleport(Entity ent, float[] rotations) {
        if (ent == Minecraft.func_71410_x().field_71439_g) {
            WorldPortals.eventHandlerClient.prevCameraRoll = WorldPortals.eventHandlerClient.cameraRoll = rotations[2];
            WorldPortals.channel.sendToServer(new PacketEntityLocation(ent));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderFront(Entity viewer, float partialTicks) {
        Vec3d position = RendererHelper.getCameraPosition(viewer, partialTicks);
        return !this.getCullRender() || this.faceOn.func_82601_c() < 0 && position.field_72450_a < this.flatPlane.field_72340_a || this.faceOn.func_82601_c() > 0 && position.field_72450_a > this.flatPlane.field_72340_a || this.faceOn.func_96559_d() < 0 && position.field_72448_b < this.flatPlane.field_72338_b || this.faceOn.func_96559_d() > 0 && position.field_72448_b > this.flatPlane.field_72338_b || this.faceOn.func_82599_e() < 0 && position.field_72449_c < this.flatPlane.field_72339_c || this.faceOn.func_82599_e() > 0 && position.field_72449_c > this.flatPlane.field_72339_c;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderDistanceChunks() {
        return iChunUtil.config.renderDistanceChunks == 0 ? Minecraft.func_71410_x().field_71474_y.field_151451_c : iChunUtil.config.renderDistanceChunks;
    }
}

