/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.recipe;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ConditionalIngredient
extends Ingredient {
    private final BooleanSupplier isConditionMet;
    private final ItemStack stackConditionMet;
    private final ItemStack stackConditionNotMet;
    private IntList packedConditionMet;
    private IntList packedConditionNotMet;

    public ConditionalIngredient(BooleanSupplier isConditionMet, ItemStack stackConditionMet, ItemStack stackConditionNotMet) {
        super(new ItemStack[0]);
        this.isConditionMet = isConditionMet;
        this.stackConditionMet = stackConditionMet;
        this.stackConditionNotMet = stackConditionNotMet;
    }

    public boolean apply(@Nullable ItemStack input) {
        int i;
        ItemStack itemStack;
        if (input == null) {
            return false;
        }
        ItemStack itemStack2 = itemStack = this.isConditionMet.getAsBoolean() ? this.stackConditionMet : this.stackConditionNotMet;
        return itemStack.func_77973_b() == input.func_77973_b() && ((i = itemStack.func_77960_j()) == Short.MAX_VALUE || i == input.func_77960_j());
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        return new ItemStack[]{this.isConditionMet.getAsBoolean() ? this.stackConditionMet : this.stackConditionNotMet};
    }

    @Nonnull
    public IntList func_194139_b() {
        IntList validStacks;
        boolean normal = this.isConditionMet.getAsBoolean();
        IntList intList = validStacks = normal ? this.packedConditionMet : this.packedConditionNotMet;
        if (validStacks == null) {
            validStacks = IntLists.singleton((int)RecipeItemHelper.func_194113_b((ItemStack)(normal ? this.stackConditionMet : this.stackConditionNotMet)));
            if (normal) {
                this.packedConditionMet = validStacks;
            } else {
                this.packedConditionNotMet = validStacks;
            }
        }
        return validStacks;
    }

    protected void invalidate() {
        super.invalidate();
        this.packedConditionMet = null;
        this.packedConditionNotMet = null;
    }

    public static ItemStack parseItemStack(JsonObject json, String identifier) {
        ResourceLocation normal = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)identifier));
        return new ItemStack((Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(normal)), JsonUtils.func_151208_a((JsonObject)json, (String)(identifier + "Count"), (int)1), JsonUtils.func_151208_a((JsonObject)json, (String)(identifier + "Data"), (int)0));
    }

    public static ConditionalIngredient parseWithCondition(BooleanSupplier condition, JsonContext context, JsonObject json) {
        ItemStack stackMet = ConditionalIngredient.parseItemStack(json, "met");
        ItemStack stackNotMet = ConditionalIngredient.parseItemStack(json, "notmet");
        return new ConditionalIngredient(condition, stackMet, stackNotMet);
    }
}

