/*
 * Decompiled with CFR 0.152.
 */
package nivoridocs.strawgolem;

import net.minecraft.block.Block;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="strawgolem")
@Config.LangKey(value="strawgolem.config.title")
@Mod.EventBusSubscriber
public class StrawgolemConfig {
    @Config.Comment(value={"Allow the straw golems to replant a crop when they harvest it."})
    public static boolean replantEnabled = false;
    @Config.Comment(value={"Set the lifespan, in tick, of new created straw golems. Set -1 for infinite."})
    @Config.RangeInt(min=-1, max=0x7FFFFFFF)
    public static int lifespan = 168000;
    @Config.Comment(value={"Sets the method for applying harvest filters.  Note that only the most specific match will be taken into consideration.", "If a crop's mod appears in the whitelist, but the crop itself is in the blacklist, the crop will be banned.", "Likewise if a crop's mod appears in the blacklist, but the crop itself is in the whitelist, the crop will be allowed.", "\"none\": allow all crops to be harvested (default).", "\"whitelist\": will deny crops from being harvested unless the most specific match is in the whitelist.", "\"blacklist\": will allows crops to be harvested unless the most specific match is in the blacklist."})
    public static String filterMode = "none";
    private static final String FILTER_MODE_WHITELIST = "whitelist";
    private static final String FILTER_MODE_BLACKLIST = "blacklist";
    @Config.Comment(value={"Whitelist Filter"})
    public static String[] whitelist = new String[0];
    @Config.Comment(value={"Blacklist Filter"})
    public static String[] blacklist = new String[0];

    public static boolean isReplantEnabled() {
        return replantEnabled;
    }

    public static int getLifespan() {
        return lifespan;
    }

    @SubscribeEvent
    public static void onConfigChange(ConfigChangedEvent.PostConfigChangedEvent event) {
        if (event.getModID().equals("strawgolem")) {
            ConfigManager.sync((String)"strawgolem", (Config.Type)Config.Type.INSTANCE);
        }
    }

    private StrawgolemConfig() {
    }

    public static boolean blockHarvestAllowed(Block block) {
        switch (filterMode) {
            case "whitelist": {
                FilterMatch whitelistMatch = StrawgolemConfig.blockMatchesFilter(block, whitelist);
                if (whitelistMatch == FilterMatch.Mod) {
                    return StrawgolemConfig.blockMatchesFilter(block, blacklist) != FilterMatch.Exact;
                }
                return whitelistMatch != FilterMatch.None;
            }
            case "blacklist": {
                FilterMatch blacklistMatch = StrawgolemConfig.blockMatchesFilter(block, whitelist);
                if (blacklistMatch == FilterMatch.Mod) {
                    return StrawgolemConfig.blockMatchesFilter(block, whitelist) == FilterMatch.Exact;
                }
                return blacklistMatch == FilterMatch.None;
            }
        }
        return true;
    }

    public static FilterMatch blockMatchesFilter(Block block, String[] filter) {
        FilterMatch bestMatch = FilterMatch.None;
        for (String s : filter) {
            String[] elements = s.split(":");
            if (elements.length == 1 && block.getRegistryName().func_110624_b().equals(elements[0])) {
                bestMatch = FilterMatch.Mod;
                continue;
            }
            if (elements.length < 2 || !block.getRegistryName().func_110624_b().equals(elements[0]) || !block.getRegistryName().func_110623_a().equals(elements[1])) continue;
            bestMatch = FilterMatch.Exact;
            break;
        }
        return bestMatch;
    }

    public static enum FilterMatch {
        None,
        Mod,
        Exact;

    }
}

