/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.torchoptimizer;

import com.kreezcraft.torchoptimizer.Overlay;
import com.kreezcraft.torchoptimizer.TorchOptimizer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class OverlayRenderer {
    private ResourceLocation texture;
    private double[] texureMinX;
    private double[] texureMaxX;
    private double[] texureMinY;
    private double[] texureMaxY;

    public void switchTexture(int textureInt) {
        this.texture = !TorchOptimizer.instance.config.optimizeEnable.getBoolean() ? new ResourceLocation("torchoptimizer", "textures/overlay.png") : new ResourceLocation("torchoptimizer", "textures/" + TorchOptimizer.instance.config.optimizedPlacement.getInt() + ".png");
    }

    public OverlayRenderer() {
        this.switchTexture(2);
        this.texureMinX = new double[64];
        this.texureMaxX = new double[64];
        this.texureMinY = new double[64];
        this.texureMaxY = new double[64];
        for (int i = 0; i < 64; ++i) {
            this.texureMinX[i] = (double)(i % 8) / 8.0;
            this.texureMaxX[i] = (double)(i % 8 + 1) / 8.0;
            this.texureMinY[i] = (double)(i / 8) / 8.0;
            this.texureMaxY[i] = (double)(i / 8 + 1) / 8.0;
        }
    }

    public void render(double x, double y, double z, ArrayList<Overlay>[][] overlays) {
        TextureManager tm = Minecraft.func_71410_x().field_71446_o;
        tm.func_110577_a(this.texture);
        BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)774, (int)0);
        vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        vb.func_178969_c(-x, -y, -z);
        for (int i = 0; i < overlays.length; ++i) {
            for (int j = 0; j < overlays[i].length; ++j) {
                for (Overlay u : overlays[i][j]) {
                    vb.func_181662_b((double)u.x, u.y, (double)u.z).func_187315_a(this.texureMinX[u.index], this.texureMinY[u.index]).func_181669_b(255, 255, 255, 255).func_181675_d();
                    vb.func_181662_b((double)u.x, u.y, (double)(u.z + 1)).func_187315_a(this.texureMinX[u.index], this.texureMaxY[u.index]).func_181669_b(255, 255, 255, 255).func_181675_d();
                    vb.func_181662_b((double)(u.x + 1), u.y, (double)(u.z + 1)).func_187315_a(this.texureMaxX[u.index], this.texureMaxY[u.index]).func_181669_b(255, 255, 255, 255).func_181675_d();
                    vb.func_181662_b((double)(u.x + 1), u.y, (double)u.z).func_187315_a(this.texureMaxX[u.index], this.texureMinY[u.index]).func_181669_b(255, 255, 255, 255).func_181675_d();
                }
            }
        }
        vb.func_178969_c(0.0, 0.0, 0.0);
        Tessellator.func_178181_a().func_78381_a();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }
}

