/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.torchoptimizer;

import com.kreezcraft.torchoptimizer.ConfigManager;
import com.kreezcraft.torchoptimizer.OverlayPoller;
import com.kreezcraft.torchoptimizer.OverlayRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.lwjgl.input.Keyboard;

@Mod(modid="torchoptimizer", name="Torch Optimizer", version="1.12.2-2.4.8", useMetadata=true, clientSideOnly=true, guiFactory="com.kreezcraft.torchoptimizer.GuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class TorchOptimizer {
    public static final String MODID = "torchoptimizer";
    public static final String NAME = "Torch Optimizer";
    public static final String VERSION = "1.12.2-2.4.8";
    @Mod.Instance(value="torchoptimizer")
    public static TorchOptimizer instance;
    public OverlayRenderer renderer;
    public OverlayPoller poller;
    public ConfigManager config;
    public boolean active;
    public KeyBinding hotkey;
    public KeyBinding plusOne;
    public KeyBinding minusOne;
    public String message;
    public double messageRemainingTicks;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        this.config = new ConfigManager(evt.getModConfigurationDirectory());
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this.config);
        this.renderer = new OverlayRenderer();
        this.poller = new OverlayPoller();
        this.active = false;
        this.hotkey = new KeyBinding("key.torchoptimizer.hotkey", 65, "key.categories.torchoptimizer");
        ClientRegistry.registerKeyBinding((KeyBinding)this.hotkey);
        this.plusOne = new KeyBinding("key.torchoptimizer.plusone", 26, "key.categories.torchoptimizer");
        ClientRegistry.registerKeyBinding((KeyBinding)this.plusOne);
        this.minusOne = new KeyBinding("key.torchoptimizer.minusone", 27, "key.categories.torchoptimizer");
        ClientRegistry.registerKeyBinding((KeyBinding)this.minusOne);
        this.launchPoller();
    }

    private void launchPoller() {
        if (this.poller.isAlive()) {
            return;
        }
        try {
            this.poller.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.poller = new OverlayPoller();
        }
    }

    @SubscribeEvent
    public void onKeyInputEvent(InputEvent.KeyInputEvent event) {
        boolean withAlt;
        boolean withShift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        boolean withCtrl = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        boolean bl = withAlt = Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
        if (this.hotkey.func_151468_f()) {
            if (this.active && withShift && !withCtrl) {
                boolean useSkyLight = !this.config.useSkyLight.getBoolean();
                this.config.useSkyLight.set(useSkyLight);
                this.message = new TextComponentTranslation("message.torchoptimizer.llo", new Object[0]).func_150254_d() + " " + (useSkyLight ? new TextComponentTranslation("message.torchoptimizer.blsl", new Object[0]).func_150254_d() : new TextComponentTranslation("message.torchoptimizer.blo", new Object[0]).func_150254_d());
                this.messageRemainingTicks = 40.0;
            } else if (this.active && withCtrl && !withShift) {
                int mode = (this.config.displayMode.getInt() + 1) % 3;
                this.config.displayMode.set(mode);
                this.message = new TextComponentTranslation("message.torchoptimizer.llo", new Object[0]).func_150254_d() + " " + this.config.displayModeName.get(mode) + " " + new TextComponentTranslation("message.torchoptimizer.mode", new Object[0]).func_150254_d();
                this.messageRemainingTicks = 40.0;
            } else if (!(withShift || withCtrl || withAlt)) {
                this.active = !this.active;
                this.launchPoller();
            }
        }
        if (this.minusOne.func_151468_f()) {
            if (this.active) {
                this.config.optimizeEnable.set(true);
                this.config.optimizedPlacement.set(this.config.optimizedPlacement.getInt() - 1);
                this.config.update();
            } else {
                this.active = !this.active;
                this.launchPoller();
            }
        }
        if (this.plusOne.func_151468_f()) {
            if (this.active) {
                this.config.optimizeEnable.set(true);
                this.config.optimizedPlacement.set(this.config.optimizedPlacement.getInt() + 1);
                this.config.update();
            } else {
                this.active = !this.active;
                this.launchPoller();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        if (this.active) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
            double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
            double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
            this.renderer.render(x, y, z, this.poller.overlays);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderGameOverlayEventText(RenderGameOverlayEvent.Text event) {
        if (this.messageRemainingTicks > 0.0) {
            this.messageRemainingTicks -= (double)event.getPartialTicks();
            event.getLeft().add(this.message);
        }
    }
}

