/*
 * Decompiled with CFR 0.152.
 */
package com.blueyu2.strata;

import com.blueyu2.strata.BlockMeta;
import com.blueyu2.strata.StrataConfig;
import com.blueyu2.strata.StrataRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.ChunkDataEvent;

public class ChunkReplacer {
    int duration = 23;
    private static final String STRATA = "Strata";

    @SubscribeEvent
    public void initGen(PopulateChunkEvent.Post event) {
        this.generate(event.world.func_72964_e(event.chunkX, event.chunkZ));
    }

    @SubscribeEvent
    public void retroGen(ChunkDataEvent.Load event) {
        if (StrataConfig.uninstall) {
            this.generate(event.getChunk());
            return;
        }
        NBTTagCompound chunkData = event.getData();
        NBTTagCompound rgen = chunkData.func_74775_l(STRATA);
        for (Block sBlock : StrataRegistry.blocks.values()) {
            if (rgen.func_74767_n(sBlock.func_149739_a())) continue;
            this.generate(event.getChunk());
        }
    }

    @SubscribeEvent
    public void retroGenSave(ChunkDataEvent.Save event) {
        NBTTagCompound chunkData = event.getData();
        NBTTagCompound rgen = chunkData.func_74775_l(STRATA);
        for (Block sBlock : StrataRegistry.blocks.values()) {
            rgen.func_74757_a(sBlock.func_149739_a(), !StrataConfig.uninstall);
        }
        chunkData.func_74782_a(STRATA, (NBTBase)rgen);
    }

    public void generate(Chunk chunk) {
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                if (!StrataConfig.uninstall) {
                    int durationCounter = 0;
                    int replaceMeta = StrataConfig.maxDepth - 1;
                    if (replaceMeta < 0) {
                        return;
                    }
                    for (int y = 0; y < 256; ++y) {
                        int meta;
                        while (chunk.func_150810_a(x, y, z) == Blocks.field_150357_h) {
                            ++y;
                        }
                        Block block = chunk.func_150810_a(x, y, z);
                        Block replace = StrataRegistry.blocks.get(StrataRegistry.getBlockMeta(block, meta = chunk.func_76628_c(x, y, z), false));
                        if (replace != null) {
                            chunk.func_150807_a(x, y, z, replace, replaceMeta);
                        }
                        if (++durationCounter < this.duration) continue;
                        durationCounter = 0;
                        if (--replaceMeta < 0) continue block1;
                    }
                    continue;
                }
                for (int y = 0; y < 256; ++y) {
                    Block block = chunk.func_150810_a(x, y, z);
                    BlockMeta replace = ChunkReplacer.getKeyByValue(StrataRegistry.blocks, block);
                    if (replace == null) continue;
                    chunk.func_150807_a(x, y, z, replace.block, replace.meta);
                }
            }
        }
    }

    public static <T, E> T getKeyByValue(Map<T, E> map, E value) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!Objects.equals(value, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }
}

