/*
 * Decompiled with CFR 0.152.
 */
package com.blueyu2.strata;

import com.blueyu2.strata.StrataBlock;
import com.blueyu2.strata.StrataRegistry;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraftforge.common.config.Configuration;

public class StrataConfig {
    public static final StrataConfig instance = new StrataConfig();
    public static final String CATEGORY_STONE = "stones.";
    public static final String CATEGORY_ORE = "ores.";
    public static File configDir = null;
    public static int maxDepth = 2;
    public static boolean uninstall = false;

    public void loadConfig(File file) {
        Configuration baseConfig = new Configuration(file, true);
        baseConfig.load();
        uninstall = baseConfig.getBoolean("Uninstall", "Main", false, "Set this to true and load any worlds with Strata installed to replace all Strata blocks in world with the original blocks. This allows for safe removal of Strata without your worlds getting ruined.");
        baseConfig.save();
        File vanillaFile = new File(configDir, "minecraft.cfg");
        if (!vanillaFile.exists()) {
            Configuration vanillaConfig = new Configuration(vanillaFile, true);
            vanillaConfig.load();
            StrataRegistry.initVanillaBlocks();
            for (Block block : StrataRegistry.blocks.values()) {
                if (!(block instanceof StrataBlock)) continue;
                StrataBlock sBlock = (StrataBlock)block;
                switch (sBlock.type) {
                    case STONE: {
                        String cat = CATEGORY_STONE + sBlock.blockId;
                        if (sBlock.meta > 0) {
                            cat = cat + ":" + sBlock.meta;
                        }
                        vanillaConfig.get(cat, "stoneTexture", sBlock.stoneTexture);
                        break;
                    }
                    case ORE: {
                        String cat = CATEGORY_ORE + sBlock.blockId;
                        if (sBlock.meta > 0) {
                            cat = cat + ":" + sBlock.meta;
                        }
                        vanillaConfig.get(cat, "oreTexture", sBlock.oreTexture);
                        vanillaConfig.get(cat, "stoneTexture", sBlock.stoneTexture);
                    }
                }
            }
            vanillaConfig.save();
        }
        if (configDir.listFiles() != null) {
            for (File configFile : configDir.listFiles()) {
                String fileName = configFile.getName();
                String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
                if (!extension.equals("cfg")) continue;
                Configuration config = new Configuration(configFile, true);
                config.load();
                for (String cat : config.getCategoryNames()) {
                    if (cat.startsWith(CATEGORY_STONE)) {
                        this.addBlock(cat, StrataBlock.Type.STONE, config);
                        continue;
                    }
                    if (!cat.startsWith(CATEGORY_ORE)) continue;
                    this.addBlock(cat, StrataBlock.Type.ORE, config);
                }
                config.save();
            }
        }
    }

    private void addBlock(String cat, StrataBlock.Type type, Configuration config) {
        Block baseBlock;
        String blockId = "NOPE";
        switch (type) {
            case STONE: {
                blockId = cat.substring(CATEGORY_STONE.length());
                break;
            }
            case ORE: {
                blockId = cat.substring(CATEGORY_ORE.length());
            }
        }
        if (blockId.equals("NOPE")) {
            return;
        }
        int index = blockId.indexOf(58);
        int meta = 0;
        try {
            String[] values = blockId.split(":");
            blockId = blockId.substring(0, values[0].length() + 1 + values[1].length());
            meta = Integer.parseInt(values[2]);
        }
        catch (Exception values) {
            // empty catch block
        }
        if (index > 1 && (baseBlock = Block.func_149684_b((String)blockId)) != null) {
            if (StrataRegistry.blocks.containsKey(StrataRegistry.getBlockMeta(baseBlock, meta, false))) {
                return;
            }
            switch (type) {
                case STONE: {
                    StrataRegistry.registerStone(blockId, meta, config.get(cat, "stoneTexture", "").getString().trim());
                    break;
                }
                case ORE: {
                    StrataRegistry.registerOre(blockId, meta, config.get(cat, "oreTexture", "").getString().trim(), config.get(cat, "stoneTexture", "").getString().trim());
                }
            }
        }
    }
}

