/*
 * Decompiled with CFR 0.152.
 */
package com.blueyu2.strata.support;

import com.blueyu2.strata.StrataBlock;
import com.blueyu2.strata.StrataConfig;
import com.blueyu2.strata.StrataRegistry;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraftforge.common.config.Configuration;

public class UBC {
    private static final String modid = "UndergroundBiomes";
    private static final String metamorphic = "metamorphic";
    private static final String sedimentary = "sedimentary";
    private static final String igneous = "igneous";
    private static final String ore = "_ore";
    private static final String overlay = "_overlay";
    private static final String[] metamorphicTypes = new String[]{"gneiss", "eclogite", "marble", "quartzite", "blueschist", "greenschist", "soapstone", "migmatite"};
    private static final String[] sedimentaryTypes = new String[]{"limestone", "chalk", "shale", "siltstone", "ligniteBlock", "dolomite", "greywacke", "chert"};
    private static final String[] igneousTypes = new String[]{"redGranite", "blackGranite", "rhyolite", "andesite", "gabbro", "basalt", "komatiite", "dacite"};
    private static final String[] stoneTypes = new String[]{"Stone", "_monsterStoneEgg"};
    private static final String[] oreTypes = new String[]{"Amber", "Cinnabar", "Coal", "Copper", "Diamond", "Emerald", "Gold", "Iron", "Lapis", "Lead", "Manganese", "Redstone", "Ruby", "Sapphire", "Silver", "Tin"};

    public static void load() {
        File ubcFile = new File(StrataConfig.configDir, "UndergroundBiomes.cfg");
        if (!ubcFile.exists()) {
            Configuration ubcConfig = new Configuration(ubcFile, true);
            ubcConfig.load();
            UBC.loadUBCBlocks();
            for (Block block : StrataRegistry.blocks.values()) {
                if (!(block instanceof StrataBlock)) continue;
                StrataBlock sBlock = (StrataBlock)block;
                if (!sBlock.blockId.substring(0, sBlock.blockId.indexOf(58)).equals(modid)) continue;
                switch (sBlock.type) {
                    case STONE: {
                        String cat = "stones." + sBlock.blockId;
                        if (sBlock.meta > 0) {
                            cat = cat + ":" + sBlock.meta;
                        }
                        ubcConfig.get(cat, "stoneTexture", sBlock.stoneTexture);
                        break;
                    }
                    case ORE: {
                        String cat = "ores." + sBlock.blockId;
                        if (sBlock.meta > 0) {
                            cat = cat + ":" + sBlock.meta;
                        }
                        ubcConfig.get(cat, "oreTexture", sBlock.oreTexture);
                        ubcConfig.get(cat, "stoneTexture", sBlock.stoneTexture);
                    }
                }
            }
            ubcConfig.save();
        }
    }

    public static void loadUBCBlocks() {
        int i;
        for (i = 0; i < metamorphicTypes.length; ++i) {
            UBC.loadUBCTypes(metamorphic, metamorphicTypes[i], i);
        }
        for (i = 0; i < sedimentaryTypes.length; ++i) {
            UBC.loadUBCTypes(sedimentary, sedimentaryTypes[i], i);
        }
        for (i = 0; i < igneousTypes.length; ++i) {
            UBC.loadUBCTypes(igneous, igneousTypes[i], i);
        }
    }

    public static void loadUBCTypes(String stone, String stoneType, int meta) {
        int i;
        for (i = 0; i < stoneTypes.length; ++i) {
            StrataRegistry.registerStone("UndergroundBiomes:" + stone + stoneTypes[i], meta, "UndergroundBiomes:" + stoneType);
        }
        for (i = 0; i < oreTypes.length; ++i) {
            StrataRegistry.registerOre("UndergroundBiomes:" + stone + ore + oreTypes[i], meta, "UndergroundBiomes:" + oreTypes[i].toLowerCase() + overlay, "UndergroundBiomes:" + stoneType);
        }
    }
}

