/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester.events;

import com.natamus.collective.data.GlobalVariables;
import com.natamus.treeharvester.config.ConfigHandler;
import com.natamus.treeharvester.util.Util;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TreeEvent {
    @SubscribeEvent
    public void onTreeHarvest(BlockEvent.BreakEvent e) {
        int logcount;
        World world = e.getWorld().func_201672_e();
        if (world.field_72995_K) {
            return;
        }
        BlockPos bpos = e.getPos();
        Block block = world.func_180495_p(bpos).func_177230_c();
        if (!Util.isTreeLog(block)) {
            return;
        }
        PlayerEntity player = e.getPlayer();
        if ((Boolean)ConfigHandler.GENERAL.treeHarvestWithoutSneak.get() != false ? player.func_225608_bj_() : !player.func_225608_bj_()) {
            return;
        }
        ItemStack hand = null;
        if (((Boolean)ConfigHandler.GENERAL.mustHoldAxeForTreeHarvest.get()).booleanValue()) {
            ItemStack mainheld = player.func_184586_b(Hand.MAIN_HAND);
            if (!mainheld.getToolTypes().contains(ToolType.AXE)) {
                return;
            }
            hand = mainheld;
        }
        if (player.func_184812_l_()) {
            hand = null;
        }
        if ((logcount = Util.isTreeAndReturnLogAmount(world, bpos)) < 0) {
            return;
        }
        int durabilitycount = Util.breakTreeAndGetDurability(world, bpos, logcount);
        if (((Boolean)ConfigHandler.GENERAL.loseDurabilityPerHarvestedLog.get()).booleanValue() && hand != null && player instanceof ServerPlayerEntity) {
            hand.func_96631_a(durabilitycount, GlobalVariables.random, (ServerPlayerEntity)player);
        }
        if (((Boolean)ConfigHandler.GENERAL.increaseExhaustionPerHarvestedLog.get()).booleanValue() && hand != null) {
            player.func_71020_j((float)((double)durabilitycount * 0.005));
        }
    }
}

