/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester.util;

import com.natamus.treeharvester.config.ConfigHandler;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Util {
    public static int isTreeAndReturnLogAmount(World world, BlockPos pos) {
        int leafcount = 20;
        int logcount = 0;
        int prevleafcount = -1;
        int prevlogcount = -1;
        for (int y = 1; y <= 30 && (prevleafcount != leafcount || prevlogcount != logcount); ++y) {
            prevleafcount = leafcount;
            prevlogcount = logcount;
            Iterator it = BlockPos.func_218287_a((int)(pos.func_177958_n() - 2), (int)(pos.func_177956_o() + (y - 1)), (int)(pos.func_177952_p() - 2), (int)(pos.func_177958_n() + 2), (int)(pos.func_177956_o() + (y - 1)), (int)(pos.func_177952_p() + 2)).iterator();
            while (it.hasNext()) {
                BlockPos npos = (BlockPos)it.next();
                Block nblock = world.func_180495_p(npos).func_177230_c();
                if (Util.isTreeLeaf(nblock)) {
                    --leafcount;
                    continue;
                }
                if (!Util.isTreeLog(nblock)) continue;
                ++logcount;
            }
        }
        if (leafcount < 0) {
            return logcount;
        }
        return -1;
    }

    private static boolean isTreeLeaf(Block block) {
        return block instanceof LeavesBlock;
    }

    public static boolean isTreeLog(Block block) {
        return block instanceof LogBlock;
    }

    public static boolean isSapling(ItemStack itemstack) {
        Item item = itemstack.func_77973_b();
        return Block.func_149634_a((Item)item) instanceof SaplingBlock;
    }

    public static int breakTreeAndGetDurability(final World world, final BlockPos pos, int logcount) {
        final ArrayList<BlockPos> bottomlogs = new ArrayList<BlockPos>();
        if (((Boolean)ConfigHandler.GENERAL.replaceSaplingIfBottomLogIsBroken.get()).booleanValue() && world.func_180495_p(pos.func_177977_b()).func_177230_c().equals(Blocks.field_150346_d)) {
            Iterator it = BlockPos.func_218287_a((int)(pos.func_177958_n() - 1), (int)pos.func_177956_o(), (int)(pos.func_177952_p() - 1), (int)(pos.func_177958_n() + 1), (int)pos.func_177956_o(), (int)(pos.func_177952_p() + 1)).iterator();
            while (it.hasNext()) {
                BlockPos npos = (BlockPos)it.next();
                Block block = world.func_180495_p(npos).func_177230_c();
                if (!Util.isTreeLog(block)) continue;
                bottomlogs.add(npos.func_185334_h());
            }
        }
        int durabilitycount = Util.breakLogArea(world, pos, 0, logcount);
        if (((Boolean)ConfigHandler.GENERAL.replaceSaplingIfBottomLogIsBroken.get()).booleanValue() && bottomlogs.size() > 0) {
            final int bls = bottomlogs.size();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    int reducecount;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    int rc = reducecount = bls;
                    ItemStack sapling = null;
                    for (Entity ea : world.func_72839_b(null, new AxisAlignedBB((double)(pos.func_177958_n() - 5), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() - 5), (double)(pos.func_177958_n() + 5), (double)(pos.func_177956_o() + 30), (double)(pos.func_177952_p() + 5)))) {
                        int count;
                        ItemEntity eia;
                        ItemStack eisa;
                        if (!(ea instanceof ItemEntity) || !Util.isSapling(eisa = (eia = (ItemEntity)ea).func_92059_d())) continue;
                        if (sapling == null) {
                            sapling = eisa.func_77946_l();
                        }
                        if ((count = eisa.func_190916_E()) > 1) {
                            for (int n = 0; n < count; ++n) {
                                eisa.func_190918_g(1);
                                if (--rc == 0) break;
                            }
                            eia.func_92058_a(eisa);
                        } else {
                            --rc;
                            eia.func_70106_y();
                        }
                        if (rc != 0) continue;
                        break;
                    }
                    int setsaplings = bottomlogs.size() - rc;
                    for (BlockPos bottompos : bottomlogs) {
                        if (setsaplings == 0) break;
                        world.func_175656_a(bottompos, Block.func_149634_a((Item)sapling.func_77973_b()).func_176223_P());
                        --setsaplings;
                    }
                }
            }).start();
        }
        return durabilitycount;
    }

    private static int breakLogArea(World world, BlockPos pos, int durabilitycount, int logcount) {
        ArrayList<BlockPos> checkaround = new ArrayList<BlockPos>();
        Iterator aroundlogs = BlockPos.func_218287_a((int)(pos.func_177958_n() - 1), (int)pos.func_177956_o(), (int)(pos.func_177952_p() - 1), (int)(pos.func_177958_n() + 1), (int)(pos.func_177956_o() + 1), (int)(pos.func_177952_p() + 1)).iterator();
        while (aroundlogs.hasNext()) {
            BlockPos nalogpos = (BlockPos)aroundlogs.next();
            Block logblock = world.func_180495_p(nalogpos).func_177230_c();
            if (!Util.isTreeLog(logblock)) continue;
            world.func_175655_b(nalogpos, true);
            checkaround.add(nalogpos.func_185334_h());
            ++durabilitycount;
            int h = 3;
            int v = 4;
            if (logcount >= 30) {
                h = 5;
                v = 5;
            } else if (logcount >= 10) {
                h = 4;
                v = 5;
            }
            Iterator aroundleaves = BlockPos.func_218287_a((int)(pos.func_177958_n() - h), (int)pos.func_177956_o(), (int)(pos.func_177952_p() - h), (int)(pos.func_177958_n() + h), (int)(pos.func_177956_o() + v), (int)(pos.func_177952_p() + h)).iterator();
            while (aroundleaves.hasNext()) {
                BlockPos naleafpos = (BlockPos)aroundleaves.next();
                Block leafblock = world.func_180495_p(naleafpos).func_177230_c();
                if (!Util.isTreeLeaf(leafblock) || !((Boolean)ConfigHandler.GENERAL.instantBreakLeavesAround.get()).booleanValue()) continue;
                world.func_175655_b(naleafpos, true);
            }
        }
        if (checkaround.size() == 0) {
            return durabilitycount;
        }
        for (BlockPos capos : checkaround) {
            durabilitycount = Util.breakLogArea(world, capos, durabilitycount, logcount);
        }
        BlockPos up = pos.func_177981_b(2);
        durabilitycount = Util.breakLogArea(world, up.func_185334_h(), durabilitycount, logcount);
        return durabilitycount;
    }
}

