/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.uglyscoreboardfix.config;

import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import me.lortseam.completeconfig.api.ConfigGroup;
import me.lortseam.completeconfig.data.Config;
import me.lortseam.uglyscoreboardfix.config.HidePart;
import me.lortseam.uglyscoreboardfix.config.HorizontalPosition;
import net.minecraft.class_124;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_5251;

public final class Settings
extends Config
implements ConfigContainer {
    public Settings() {
        super("uglyscoreboardfix", new ConfigContainer[0]);
    }

    @ConfigContainer.Transitive
    @ConfigEntries
    public static final class Sidebar
    implements ConfigGroup {
        @ConfigEntry.BoundedFloat(min=0.1f, max=10.0f)
        private static float scale = 1.0f;

        private Sidebar() {
        }

        public static float getScale() {
            return scale;
        }

        @ConfigContainer.Transitive
        @ConfigEntries
        public static final class Hiding
        implements ConfigGroup {
            @ConfigEntry(comment="ENABLED or DISABLED or AUTO (only enabled when scores are in consecutive order)")
            private static State state = State.AUTO;
            @ConfigEntry(comment="SCORES or SIDEBAR")
            private static HidePart hidePart = HidePart.SCORES;

            public static boolean shouldHide(HidePart part, class_266 objective) {
                return part == hidePart && state.test(objective);
            }

            private Hiding() {
            }

            private static enum State {
                ENABLED{

                    @Override
                    boolean test(class_266 objective) {
                        return true;
                    }
                }
                ,
                AUTO{

                    @Override
                    boolean test(class_266 objective) {
                        int[] scores = objective.method_1117().method_1184(objective).stream().mapToInt(class_267::method_1126).toArray();
                        if (scores.length >= 2) {
                            for (int i = 1; i < scores.length; ++i) {
                                if (scores[i - 1] + 1 == scores[i]) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                }
                ,
                DISABLED{

                    @Override
                    boolean test(class_266 objective) {
                        return false;
                    }
                };


                abstract boolean test(class_266 var1);
            }
        }

        @ConfigContainer.Transitive
        @ConfigEntries
        public static final class Background
        implements ConfigGroup {
            @ConfigEntry.Color(alphaMode=true)
            private static int headingColor = 0x66000000;
            @ConfigEntry.Color(alphaMode=true)
            private static int color = 0x4C000000;

            private Background() {
            }

            public static int getHeadingColor() {
                return headingColor;
            }

            public static int getColor() {
                return color;
            }
        }

        @ConfigContainer.Transitive
        @ConfigEntries
        public static final class Text
        implements ConfigGroup {
            private static class_5251 headingColor = class_5251.method_27718((class_124)class_124.field_1068);
            private static class_5251 color = class_5251.method_27718((class_124)class_124.field_1068);
            private static class_5251 scoreColor = class_5251.method_27718((class_124)class_124.field_1061);

            private Text() {
            }

            public static class_5251 getHeadingColor() {
                return headingColor;
            }

            public static class_5251 getColor() {
                return color;
            }

            public static class_5251 getScoreColor() {
                return scoreColor;
            }
        }

        @ConfigContainer.Transitive
        @ConfigEntries
        public static final class Position
        implements ConfigGroup {
            @ConfigEntry(comment="RIGHT (default) or LEFT")
            private static HorizontalPosition x = HorizontalPosition.RIGHT;
            private static int yOffset = 0;

            private Position() {
            }

            public static HorizontalPosition getX() {
                return x;
            }

            public static int getYOffset() {
                return yOffset;
            }
        }
    }
}

