/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.upsizer;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class UpsConfig {
    static final int FULL_STACK = 64;
    static final int HALF_STACK = 32;
    static final int MINI_STACK = 16;
    static final int NANO_STACK = 4;
    private static final String _I18N = "upsizer.configui.";
    private static final String _CONTROL = "control.";
    private static final String _UPSIZED = "upsized.";
    private static final String _STORAGE = "storage.";
    private static final String _OTHERS = "integration.";
    private static final Pair<UpsConfig, ForgeConfigSpec> _impl = new ForgeConfigSpec.Builder().configure(UpsConfig::new);
    static final ForgeConfigSpec SPEC = (ForgeConfigSpec)_impl.getValue();
    private static final UpsConfig INSTANCE = (UpsConfig)_impl.getKey();
    private ForgeConfigSpec.Builder _builder;
    private final Map<String, Object> _cache = new HashMap<String, Object>(71);

    static final UpsConfig getInstance() {
        return INSTANCE;
    }

    UpsConfig(@Nonnull ForgeConfigSpec.Builder builder) {
        this.fullyDefine(builder);
    }

    public boolean isDebugMode() {
        String NAME = "debug_mode";
        String PROPERTY = "control.debug_mode";
        ForgeConfigSpec.BooleanValue b = (ForgeConfigSpec.BooleanValue)this._cache.get("control.debug_mode");
        if (b != null) {
            return (Boolean)b.get();
        }
        if (this._builder != null) {
            b = this._builder.translation("upsizer.configui.debug_mode").comment("INTERNAL. Development messages enabled.").define("control.debug_mode", false);
            this._cache.put("control.debug_mode", b);
        }
        return false;
    }

    public boolean isDownsizable() {
        String NAME = "allow_downsizing";
        String PROPERTY = "control.allow_downsizing";
        ForgeConfigSpec.BooleanValue b = (ForgeConfigSpec.BooleanValue)this._cache.get("control.allow_downsizing");
        if (b != null) {
            return (Boolean)b.get();
        }
        if (this._builder != null) {
            b = this._builder.translation("upsizer.configui.allow_downsizing").comment("Set to true to enable upsizer to DOWN-size an item's max stack size. Disabled by default.").define("control.allow_downsizing", false);
            this._cache.put("control.allow_downsizing", b);
        }
        return false;
    }

    public boolean touch(String item, String id, boolean defaultFlag) {
        String NAME = "check_" + id;
        String PROPERTY = _CONTROL + NAME;
        ForgeConfigSpec.BooleanValue b = (ForgeConfigSpec.BooleanValue)this._cache.get(PROPERTY);
        if (b != null) {
            return (Boolean)b.get();
        }
        if (this._builder != null) {
            b = this._builder.translation(_I18N + NAME).comment("Set to true to enable upsizer for " + item + ". You also need to update your preferred max stack count in the proper section. " + (defaultFlag ? "Enabled" : "Disabled") + " by default.").define(PROPERTY, defaultFlag);
            this._cache.put(PROPERTY, b);
        }
        return defaultFlag;
    }

    private int _upsizedStackFor(String item, String id, int defaultSize) {
        String NAME = id + "_upsized_stack";
        String PROPERTY = _UPSIZED + NAME;
        ForgeConfigSpec.IntValue n = (ForgeConfigSpec.IntValue)this._cache.get(PROPERTY);
        if (n != null) {
            return (Integer)n.get();
        }
        if (this._builder != null) {
            n = this._builder.translation(_I18N + NAME).comment("New stack size for " + item + "; default is " + defaultSize + ".").defineInRange(PROPERTY, defaultSize, 1, 64);
            this._cache.put(PROPERTY, n);
        }
        return defaultSize;
    }

    private int upsizedStackFor(String item, String id, boolean onFlag) {
        int n = this._upsizedStackFor(item, id, 64);
        return this.touch(item, id, onFlag) ? n : -1;
    }

    private int upsizedStackFor(String item, String id, int defaultSize, boolean onFlag) {
        int n = this._upsizedStackFor(item, id, defaultSize);
        return this.touch(item, id, onFlag) ? n : -1;
    }

    private int _storageStackFor(String item, String id, int defaultSize) {
        String NAME = id + "_storage_stack";
        String PROPERTY = _STORAGE + NAME;
        ForgeConfigSpec.IntValue n = (ForgeConfigSpec.IntValue)this._cache.get(PROPERTY);
        if (n != null) {
            return (Integer)n.get();
        }
        if (this._builder != null) {
            n = this._builder.translation(_I18N + NAME).comment("New storage stack for " + item + "; default is " + defaultSize + ".").defineInRange(PROPERTY, defaultSize, 1, 64);
            this._cache.put(PROPERTY, n);
        }
        return defaultSize;
    }

    private int storageStackFor(String item, String id, boolean onFlag) {
        int n = this._storageStackFor(item, id, 1);
        return this.touch(item, id, onFlag) ? n : -1;
    }

    private int storageStackFor(String item, String id, int defaultSize, boolean onFlag) {
        int n = this._storageStackFor(item, id, defaultSize);
        return this.touch(item, id, onFlag) ? n : -1;
    }

    public int maxStackRawEggs() {
        return this.upsizedStackFor("raw eggs", "eggs", true);
    }

    public int maxStackSnowballs() {
        return this.upsizedStackFor("snow balls", "snowballs", true);
    }

    public int maxStackHoneyBottles() {
        return this.upsizedStackFor("honey bottles", "honey_bottles", true);
    }

    public int maxStackSigns() {
        return this.upsizedStackFor("signs", "signs", true);
    }

    public int maxStackBuckets() {
        return this.upsizedStackFor("empty buckets", "buckets", 32, true);
    }

    public int maxStackEnderPearls() {
        return this.upsizedStackFor("ender pearls", "ender_pearls", true);
    }

    public int maxStackBanners() {
        return this.upsizedStackFor("banners", "banners", 32, true);
    }

    public int maxStackBannerPatterns() {
        return this.upsizedStackFor("banner patterns", "banner_patterns", 4, false);
    }

    public int maxStackArmorstands() {
        return this.upsizedStackFor("armor stands", "armorstands", true);
    }

    public int maxStackWaterBuckets() {
        return this.storageStackFor("filled water buckets", "water_buckets", false);
    }

    public int maxStackMilkBuckets() {
        return this.storageStackFor("filled milk buckets", "milk_buckets", false);
    }

    public int maxStackLavaBuckets() {
        return this.storageStackFor("filled lava buckets", "lava_buckets", false);
    }

    public int maxStackCakes() {
        return this.storageStackFor("baked cakes", "cakes", 4, true);
    }

    public int maxStackStews() {
        return this.storageStackFor("stews and soups", "stews", false);
    }

    public int maxStackTools() {
        return this.storageStackFor("tools", "tools", false);
    }

    public int maxStackWeapons() {
        return this.storageStackFor("weapons", "weapons", false);
    }

    public int maxStackHorseArmor() {
        return this.storageStackFor("horse armor", "horse_armor", 16, true);
    }

    public int maxStackEmptyMinecarts() {
        return this.storageStackFor("empty minecarts", "minecarts", 4, false);
    }

    public int maxStackBoats() {
        return this.storageStackFor("wooden boats", "boats", 4, true);
    }

    public int maxStackBeds() {
        return this.storageStackFor("beds", "beds", false);
    }

    public int maxStackSaddles() {
        return this.storageStackFor("saddles", "saddles", 16, true);
    }

    public int maxStackShields() {
        return this.storageStackFor("shields", "shields", false);
    }

    public int maxStackRecords() {
        return this.storageStackFor("records", "records", 16, true);
    }

    public int maxStackPotions() {
        return this.storageStackFor("potion bottles", "potions", 4, false);
    }

    public int maxStackWritableBooks() {
        return this.storageStackFor("writable books", "writable_books", 16, true);
    }

    public int maxStackEnchantBooks() {
        return this.storageStackFor("enchanted books", "enchanted_books", 4, true);
    }

    public Map<String, Integer> getCustomStackDefs() {
        String NAME = "__other_maxstack_sizes_map";
        String PROPERTY = "integration.__other_maxstack_sizes_map";
        HashMap<String, Integer> mappings = (HashMap<String, Integer>)Map.class.cast(this._cache.get("integration.__other_maxstack_sizes_map"));
        if (mappings != null) {
            return this.touch("other objects", "other_objects", true) ? mappings : Collections.EMPTY_MAP;
        }
        mappings = new HashMap<String, Integer>();
        List<? extends String> keyvalues = this.getCustomStackDefs_();
        if (keyvalues != null && !keyvalues.isEmpty()) {
            for (String string : keyvalues) {
                int n = 64;
                String id = string;
                int i = string.lastIndexOf(61);
                if (i > 0) {
                    id = string.substring(0, i);
                    n = NumberUtils.toInt((String)string.substring(i + 1), (int)-1);
                }
                if (n <= 0) continue;
                mappings.put(id, n);
            }
        }
        this._cache.put("integration.__other_maxstack_sizes_map", mappings);
        return mappings;
    }

    private List<? extends String> getCustomStackDefs_() {
        String NAME = "other_maxstack_sizes";
        String PROPERTY = "integration.other_maxstack_sizes";
        ForgeConfigSpec.ConfigValue l = (ForgeConfigSpec.ConfigValue)ForgeConfigSpec.ConfigValue.class.cast(this._cache.get("integration.other_maxstack_sizes"));
        if (l != null) {
            return (List)l.get();
        }
        if (this._builder != null) {
            l = this._builder.translation("upsizer.configui.other_maxstack_sizes").comment("Set to the fully qualified item or block names with stack sizes mappings for additional up-sized objects. The expected format for each string is NAME=MAXSTACK.").defineList("integration.other_maxstack_sizes", Arrays.asList("minecraft:totem_of_undying=1", "minecraft:shulker_box=1"), o -> o instanceof String);
            this._cache.put("integration.other_maxstack_sizes", l);
            this.touch("other objects", "other_objects", true);
        }
        return Collections.EMPTY_LIST;
    }

    static final File getFile() {
        return FMLPaths.CONFIGDIR.get().resolve("wabbity_upsizer.toml").toFile();
    }

    private void fullyDefine(@Nonnull ForgeConfigSpec.Builder builder) {
        this._builder = builder;
        this._cache.clear();
        try {
            this.isDebugMode();
            this.isDownsizable();
            this.maxStackRawEggs();
            this.maxStackSnowballs();
            this.maxStackSigns();
            this.maxStackRecords();
            this.maxStackBuckets();
            this.maxStackEnderPearls();
            this.maxStackWaterBuckets();
            this.maxStackMilkBuckets();
            this.maxStackLavaBuckets();
            this.maxStackCakes();
            this.maxStackStews();
            this.maxStackHoneyBottles();
            this.maxStackTools();
            this.maxStackHorseArmor();
            this.maxStackWeapons();
            this.maxStackShields();
            this.maxStackEmptyMinecarts();
            this.maxStackBoats();
            this.maxStackSaddles();
            this.maxStackBanners();
            this.maxStackBannerPatterns();
            this.maxStackArmorstands();
            this.maxStackBeds();
            this.maxStackPotions();
            this.maxStackWritableBooks();
            this.maxStackEnchantBooks();
            this.getCustomStackDefs_();
        }
        finally {
            this._builder = null;
        }
    }
}

