/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.upsizer;

import cpw.mods.modlauncher.api.INameMappingService;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jwaresoftware.mcmods.upsizer.UpsConfig;

@Mod(value="upsizer")
@Mod.EventBusSubscriber(modid="upsizer", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Upsizer {
    private static final Logger _modLog = LogManager.getLogger((String)"UpS");
    public static Upsizer instance;
    private Field _MAXSIZE_FIELD = null;
    private UpsConfig _config;
    private boolean _allowDownsizing = false;

    public Upsizer() {
        instance = this;
        this.readField();
        this._config = UpsConfig.getInstance();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, UpsConfig.SPEC, UpsConfig.getFile().getPath());
        if (this._MAXSIZE_FIELD != null) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::updateVanilla);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::updateModded);
        }
    }

    private void updateVanilla(FMLCommonSetupEvent event) {
        this._allowDownsizing = this._config.isDownsizable();
        this.adjust(Items.field_151110_aK, this._config.maxStackRawEggs());
        this.adjust(Items.field_151133_ar, this._config.maxStackBuckets());
        this.adjust(Items.field_151079_bi, this._config.maxStackEnderPearls());
        this.adjust(Items.field_151126_ay, this._config.maxStackSnowballs());
        this.adjust(Items.field_226638_pX_, this._config.maxStackHoneyBottles());
        this.adjust(Items.field_151131_as, this._config.maxStackWaterBuckets());
        this.adjust(Items.field_151117_aB, this._config.maxStackMilkBuckets());
        this.adjust(Items.field_151129_at, this._config.maxStackLavaBuckets());
        this.adjust(Items.field_151143_au, this._config.maxStackEmptyMinecarts());
        this.adjust(Items.field_151141_av, this._config.maxStackSaddles());
        this.adjust(Items.field_185159_cQ, this._config.maxStackShields());
        this.adjust(Blocks.field_150414_aQ, this._config.maxStackCakes());
        this.adjust(Items.field_151134_bR, this._config.maxStackEnchantBooks());
        this.adjust(Items.field_151099_bA, this._config.maxStackWritableBooks());
        int n = this._config.maxStackSigns();
        if (n > 1) {
            this.adjust(Items.field_222071_kr, n);
            this.adjust(Items.field_222072_ks, n);
            this.adjust(Items.field_222073_kt, n);
            this.adjust(Items.field_222074_ku, n);
            this.adjust(Items.field_222075_kv, n);
            this.adjust(Items.field_222076_kw, n);
        }
        if ((n = this._config.maxStackStews()) > 1) {
            this.adjust(Items.field_179560_bq, n);
            this.adjust(Items.field_151009_A, n);
            this.adjust(Items.field_185165_cW, n);
            this.adjust(Items.field_222115_pz, n);
        }
        if ((n = this._config.maxStackTools()) > 1) {
            this.adjust(Items.field_151033_d, n);
            this.adjust(Items.field_151097_aZ, n);
            this.adjust(Items.field_151112_aM, n);
            this.adjust(Items.field_151146_bM, n);
            this.adjust(Items.field_151053_p, n);
            this.adjust(Items.field_151039_o, n);
            this.adjust(Items.field_151038_n, n);
            this.adjust(Items.field_151017_I, n);
            this.adjust(Items.field_151049_t, n);
            this.adjust(Items.field_151050_s, n);
            this.adjust(Items.field_151051_r, n);
            this.adjust(Items.field_151018_J, n);
            this.adjust(Items.field_151036_c, n);
            this.adjust(Items.field_151035_b, n);
            this.adjust(Items.field_151037_a, n);
            this.adjust(Items.field_151019_K, n);
            this.adjust(Items.field_151006_E, n);
            this.adjust(Items.field_151005_D, n);
            this.adjust(Items.field_151011_C, n);
            this.adjust(Items.field_151013_M, n);
            this.adjust(Items.field_151056_x, n);
            this.adjust(Items.field_151046_w, n);
            this.adjust(Items.field_151047_v, n);
            this.adjust(Items.field_151012_L, n);
        }
        if ((n = this._config.maxStackWeapons()) > 1) {
            this.adjust(Items.field_151031_f, n);
            this.adjust(Items.field_222114_py, n);
            this.adjust(Items.field_151041_m, n);
            this.adjust(Items.field_151052_q, n);
            this.adjust(Items.field_151024_Q, n);
            this.adjust(Items.field_151027_R, n);
            this.adjust(Items.field_151026_S, n);
            this.adjust(Items.field_151021_T, n);
            this.adjust(Items.field_151040_l, n);
            this.adjust(Items.field_151028_Y, n);
            this.adjust(Items.field_151030_Z, n);
            this.adjust(Items.field_151165_aa, n);
            this.adjust(Items.field_151167_ab, n);
            this.adjust(Items.field_151010_B, n);
            this.adjust(Items.field_151169_ag, n);
            this.adjust(Items.field_151171_ah, n);
            this.adjust(Items.field_151149_ai, n);
            this.adjust(Items.field_151151_aj, n);
            this.adjust(Items.field_151048_u, n);
            this.adjust(Items.field_151161_ac, n);
            this.adjust(Items.field_151163_ad, n);
            this.adjust(Items.field_151173_ae, n);
            this.adjust(Items.field_151175_af, n);
            this.adjust(Items.field_151020_U, n);
            this.adjust(Items.field_151023_V, n);
            this.adjust(Items.field_151022_W, n);
            this.adjust(Items.field_151029_X, n);
            this.adjust(Items.field_203184_eO, n);
            this.adjust(Items.field_203179_ao, n);
        }
        if ((n = this._config.maxStackHorseArmor()) > 1) {
            this.adjust(Items.field_222110_op, n);
            this.adjust(Items.field_151138_bX, n);
            this.adjust(Items.field_151136_bY, n);
            this.adjust(Items.field_151125_bZ, n);
        }
        if ((n = this._config.maxStackBoats()) > 1) {
            this.adjust(Items.field_151124_az, n);
            this.adjust(Items.field_185154_aL, n);
            this.adjust(Items.field_185151_aI, n);
            this.adjust(Items.field_185153_aK, n);
            this.adjust(Items.field_185152_aJ, n);
            this.adjust(Items.field_185150_aH, n);
        }
        if ((n = this._config.maxStackRecords()) > 1) {
            this.adjust(Items.field_196156_dS, n);
            this.adjust(Items.field_196158_dT, n);
            this.adjust(Items.field_196160_dU, n);
            this.adjust(Items.field_196162_dV, n);
            this.adjust(Items.field_196164_dW, n);
            this.adjust(Items.field_196166_dX, n);
            this.adjust(Items.field_196168_dY, n);
            this.adjust(Items.field_196170_dZ, n);
            this.adjust(Items.field_196187_ea, n);
            this.adjust(Items.field_196188_eb, n);
            this.adjust(Items.field_196189_ec, n);
            this.adjust(Items.field_196190_ed, n);
        }
        n = this._config.maxStackBanners();
        if (this._allowDownsizing || n > 1) {
            this.adjust(Items.field_196191_eg, n);
            this.adjust(Items.field_196192_eh, n);
            this.adjust(Items.field_196193_ei, n);
            this.adjust(Items.field_196194_ej, n);
            this.adjust(Items.field_196195_ek, n);
            this.adjust(Items.field_196196_el, n);
            this.adjust(Items.field_196197_em, n);
            this.adjust(Items.field_196198_en, n);
            this.adjust(Items.field_196199_eo, n);
            this.adjust(Items.field_196200_ep, n);
            this.adjust(Items.field_196201_eq, n);
            this.adjust(Items.field_196202_er, n);
            this.adjust(Items.field_196203_es, n);
            this.adjust(Items.field_196204_et, n);
            this.adjust(Items.field_196205_eu, n);
            this.adjust(Items.field_196206_ev, n);
        }
        if ((n = this._config.maxStackBannerPatterns()) > 1) {
            this.adjust(Items.field_222095_pB, n);
            this.adjust(Items.field_222096_pC, n);
            this.adjust(Items.field_222097_pD, n);
            this.adjust(Items.field_222098_pE, n);
            this.adjust(Items.field_222099_pF, n);
        }
        if ((n = this._config.maxStackBeds()) > 1) {
            this.adjust(Items.field_196140_bu, n);
            this.adjust(Items.field_196142_bv, n);
            this.adjust(Items.field_196144_bw, n);
            this.adjust(Items.field_196146_bx, n);
            this.adjust(Items.field_196148_by, n);
            this.adjust(Items.field_196150_bz, n);
            this.adjust(Items.field_196090_bA, n);
            this.adjust(Items.field_196091_bB, n);
            this.adjust(Items.field_196092_bC, n);
            this.adjust(Items.field_196093_bD, n);
            this.adjust(Items.field_196094_bE, n);
            this.adjust(Items.field_196095_bF, n);
            this.adjust(Items.field_196096_bG, n);
            this.adjust(Items.field_196097_bH, n);
            this.adjust(Items.field_196098_bI, n);
            this.adjust(Items.field_196099_bJ, n);
        }
        if ((n = this._config.maxStackPotions()) > 1) {
            this.adjust(Items.field_151068_bn, n);
            this.adjust(Items.field_185155_bH, n);
            this.adjust(Items.field_185156_bI, n);
        }
    }

    private void updateModded(InterModProcessEvent event) {
        Map<String, Integer> custom = this._config.getCustomStackDefs();
        for (Map.Entry<String, Integer> e : custom.entrySet()) {
            this.adjust(e.getKey(), (int)e.getValue());
        }
    }

    private void adjust(Item item, int preferredSize) {
        if (preferredSize > 0 && (this._allowDownsizing || item.getItemStackLimit(new ItemStack((IItemProvider)item)) < preferredSize)) {
            this.resize(item, preferredSize);
        }
    }

    private void adjust(Block blok, int preferredSize) {
        this.adjust(blok.func_199767_j(), preferredSize);
    }

    private void adjust(String id, int preferredSize) {
        Item item;
        ResourceLocation r = ResourceLocation.func_208304_a((String)id);
        if (r != null && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id))) != null && item != Items.field_190931_a) {
            this.adjust(item, preferredSize);
        }
    }

    private void readField() {
        try {
            Field field = Item.class.getDeclaredField(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.FIELD, (String)"field_77777_bU"));
            field.setAccessible(true);
            this._MAXSIZE_FIELD = field;
            _modLog.debug("Item.maxSize set accessible");
        }
        catch (Throwable igX) {
            _modLog.catching(Level.WARN, igX);
        }
    }

    private void resize(Item item, int preferredSize) {
        try {
            int old = this._MAXSIZE_FIELD.getInt(item);
            this._MAXSIZE_FIELD.setInt(item, preferredSize);
            if (this._config.isDebugMode() && _modLog.isDebugEnabled()) {
                _modLog.debug(" {} -> {} , {}", (Object)item.getClass().getSimpleName(), (Object)old, (Object)this._MAXSIZE_FIELD.getInt(item));
            }
        }
        catch (Throwable igX) {
            _modLog.catching(Level.DEBUG, igX);
        }
    }
}

