/*
 * Decompiled with CFR 0.152.
 */
package draylar.wolveswitharmor.item;

import draylar.wolveswitharmor.WolvesWithArmor;
import draylar.wolveswitharmor.data.WolfArmorData;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WolfArmorItem
extends Item {
    private final int bonus;
    private final ResourceLocation entityTexture;

    public WolfArmorItem(WolfArmorData data) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(WolvesWithArmor.GROUP));
        this.bonus = data.getBonus();
        this.entityTexture = WolvesWithArmor.id("textures/entity/wolf/armor/wolf_armor_" + data.getName() + ".png");
    }

    public WolfArmorItem(WolfArmorData data, boolean isFireproof) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(WolvesWithArmor.GROUP).func_234689_a_());
        this.bonus = data.getBonus();
        this.entityTexture = WolvesWithArmor.id("textures/entity/wolf/armor/wolf_armor_" + data.getName() + ".png");
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getEntityTexture() {
        return this.entityTexture;
    }

    public int getBonus(ItemStack stack) {
        int protectionLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180310_c, (ItemStack)stack) * 2;
        return this.bonus + protectionLevel;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag context) {
        super.func_77624_a(stack, world, tooltip, context);
        tooltip.add((ITextComponent)new StringTextComponent(""));
        tooltip.add((ITextComponent)new TranslationTextComponent("wolveswitharmor.tooltip.when_equipped").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("wolveswitharmor.tooltip.bonus", new Object[]{this.getBonus(stack)}).func_240699_a_(TextFormatting.BLUE));
        if (stack.func_77948_v()) {
            tooltip.add((ITextComponent)new StringTextComponent(""));
        }
    }
}

