/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.client.debug;

import CoroUtil.client.debug.DebugRenderEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityCreature;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class DebugRenderer {
    private static List<DebugRenderEntry> listRenderables = new ArrayList<DebugRenderEntry>();

    public static void addRenderable(DebugRenderEntry entry) {
        listRenderables.add(entry);
    }

    public static void tickClient() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        ListIterator<DebugRenderEntry> it = listRenderables.listIterator();
        while (it.hasNext()) {
            DebugRenderEntry entry = (DebugRenderEntry)it.next();
            if (!entry.isExpired((World)world)) continue;
            it.remove();
        }
        if (listRenderables.size() > 0) {
            it = listRenderables.listIterator();
            while (it.hasNext()) {
                DebugRenderEntry debugRenderEntry = (DebugRenderEntry)it.next();
            }
        }
    }

    public static void renderDebug(RenderWorldLastEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        if (listRenderables.size() > 0) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferBuilder = tessellator.func_178180_c();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            ListIterator<DebugRenderEntry> it = listRenderables.listIterator();
            while (it.hasNext()) {
                DebugRenderEntry entry = (DebugRenderEntry)it.next();
                entry.addToBuffer(bufferBuilder);
            }
            DebugRenderer.renderBatch(tessellator, bufferBuilder);
            it = listRenderables.listIterator();
            while (it.hasNext()) {
                DebugRenderEntry debugRenderEntry = (DebugRenderEntry)it.next();
            }
        }
    }

    public static void renderBatch(Tessellator tessellator, BufferBuilder bufferBuilder) {
        RenderHelper.func_74518_a();
        boolean translucency = true;
        if (translucency) {
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179147_l();
        } else {
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)false);
        }
        GlStateManager.func_179090_x();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        RenderManager rm = Minecraft.func_71410_x().func_175598_ae();
        tessellator.func_78381_a();
        if (!translucency) {
            GlStateManager.func_179147_l();
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
        RenderHelper.func_74519_b();
    }

    public static void debugPathfinding(EntityCreature ent) {
        if (!ent.field_70170_p.field_72995_K && !ent.func_70661_as().func_75500_f()) {
            for (int k = 0; k < ent.func_70661_as().func_75505_d().func_75874_d(); ++k) {
                PathPoint pathpoint2 = ent.func_70661_as().func_75505_d().func_75877_a(k);
                DebugRenderer.addRenderable(new DebugRenderEntry(new BlockPos(pathpoint2.field_75839_a, pathpoint2.field_75837_b, pathpoint2.field_75838_c), ent.field_70170_p.func_82737_E() + 100L, 65280));
            }
        }
    }

    public static void clearRenderables() {
        listRenderables.clear();
    }
}

