/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.difficulty;

import CoroUtil.world.WorldDirector;
import CoroUtil.world.WorldDirectorManager;
import CoroUtil.world.location.TickableLocationBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class BuffedLocation
extends TickableLocationBase {
    private boolean isDebuff;
    public int buffDistRadius = 32;
    public float difficulty = 1.0f;
    private boolean tickDecay = false;
    private int age = 0;
    private int maxAge = 12000;

    public BuffedLocation() {
    }

    public BuffedLocation(int buffDistRadius, float difficulty) {
        this.buffDistRadius = buffDistRadius;
        this.difficulty = difficulty;
    }

    public boolean isDebuff() {
        return this.isDebuff;
    }

    public void setDebuff(boolean debuff) {
        this.isDebuff = debuff;
    }

    public boolean isTickDecay() {
        return this.tickDecay;
    }

    public void setDecays(boolean tickDecay) {
        this.tickDecay = tickDecay;
    }

    @Override
    public void init() {
    }

    @Override
    public void initPost() {
    }

    @Override
    public void tickUpdate() {
        World world = this.getWorld();
        if (this.tickDecay) {
            ++this.age;
            if (this.age >= this.maxAge) {
                this.remove();
                return;
            }
        }
        if (world.func_82737_E() % 40L == 0L) {
            // empty if block
        }
    }

    public void remove() {
        WorldDirector wd = WorldDirectorManager.instance().getCoroUtilWorldDirector(this.getWorld());
        if (wd != null) {
            wd.removeTickingLocation(this);
        }
    }

    @Override
    public void tickUpdateThreaded() {
    }

    @Override
    public void readFromNBT(NBTTagCompound parData) {
        super.readFromNBT(parData);
        this.difficulty = parData.func_74760_g("difficulty");
        this.buffDistRadius = parData.func_74762_e("radius");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound parData) {
        parData = super.writeToNBT(parData);
        parData.func_74768_a("radius", this.buffDistRadius);
        parData.func_74776_a("difficulty", this.difficulty);
        return parData;
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }

    @Override
    public boolean isThreaded() {
        return false;
    }
}

