/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.difficulty.buffs;

import CoroUtil.ai.BehaviorModifier;
import CoroUtil.difficulty.UtilEntityBuffs;
import CoroUtil.difficulty.buffs.BuffBase;
import net.minecraft.entity.EntityCreature;

public class BuffAI_TaskBase
extends BuffBase {
    protected String buffName;
    protected Class task;
    protected Class taskToReplace;
    protected int taskPriority;
    protected float minRequiredDifficulty = 0.0f;
    protected boolean isTargetTask = false;
    protected boolean allowRedundantAttempts = false;

    public BuffAI_TaskBase(String buffName, Class task, int taskPriority, Class taskToReplace) {
        this(buffName, task, taskPriority);
        this.taskToReplace = taskToReplace;
    }

    public BuffAI_TaskBase(String buffName, Class task, int taskPriority) {
        this.buffName = buffName;
        this.task = task;
        this.taskPriority = taskPriority;
    }

    public BuffAI_TaskBase setAllowRedundantAttempts() {
        this.allowRedundantAttempts = true;
        return this;
    }

    @Override
    public String getTagName() {
        return this.buffName;
    }

    @Override
    public float getMinRequiredDifficulty() {
        return this.minRequiredDifficulty;
    }

    public void setMinRequiredDifficulty(float minRequiredDifficulty) {
        this.minRequiredDifficulty = minRequiredDifficulty;
    }

    @Override
    public boolean applyBuff(EntityCreature ent, float difficulty) {
        if (this.applyBuffImpl(ent, difficulty, true) || this.allowRedundantAttempts) {
            return super.applyBuff(ent, difficulty);
        }
        return false;
    }

    @Override
    public boolean canApplyBuff(EntityCreature ent, float difficulty) {
        return !UtilEntityBuffs.hasTask(ent, this.task, this.isTargetTask) || this.allowRedundantAttempts;
    }

    @Override
    public void applyBuffFromReload(EntityCreature ent, float difficulty) {
        if (this.canApplyBuff(ent, difficulty)) {
            this.applyBuffImpl(ent, difficulty, false);
        }
    }

    public boolean applyBuffImpl(EntityCreature ent, float difficulty, boolean firstTime) {
        if (this.taskToReplace != null) {
            return BehaviorModifier.replaceTaskIfMissing(ent, this.taskToReplace, this.task, this.taskPriority, this.isTargetTask);
        }
        if (!UtilEntityBuffs.hasTask(ent, this.task, this.isTargetTask)) {
            return UtilEntityBuffs.addTask(ent, this.task, this.taskPriority, this.isTargetTask);
        }
        return false;
    }

    public boolean isTargetTask() {
        return this.isTargetTask;
    }

    public void setTargetTask(boolean targetTask) {
        this.isTargetTask = targetTask;
    }
}

