/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.difficulty.data;

import CoroUtil.config.ConfigCoroUtil;
import CoroUtil.difficulty.UtilEntityBuffs;
import CoroUtil.difficulty.data.DataCmod;
import CoroUtil.difficulty.data.DataCmodTemplate;
import CoroUtil.difficulty.data.DataCondition;
import CoroUtil.difficulty.data.DataConditionTemplate;
import CoroUtil.difficulty.data.DifficultyData;
import CoroUtil.difficulty.data.DifficultyDataReader;
import CoroUtil.difficulty.data.cmods.CmodInventory;
import CoroUtil.difficulty.data.cmods.CmodInventoryDifficultyScaled;
import CoroUtil.difficulty.data.cmods.CmodInventoryEntry;
import CoroUtil.difficulty.data.cmods.CmodTemplateReference;
import CoroUtil.difficulty.data.conditions.ConditionTemplateReference;
import CoroUtil.difficulty.data.spawns.DataActionMobSpawns;
import CoroUtil.difficulty.data.spawns.DataMobSpawnsTemplate;
import CoroUtil.forge.CULog;
import CoroUtil.forge.CoroUtil;
import CoroUtil.util.EnumSpawnPlacementType;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class DeserializerAllJson
implements JsonDeserializer<DifficultyData> {
    public DifficultyData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        DifficultyData data;
        block9: {
            String format;
            JsonObject obj;
            block10: {
                block8: {
                    obj = json.getAsJsonObject();
                    JsonElement eleFormat = obj.get("format");
                    format = eleFormat.getAsString();
                    data = DifficultyDataReader.getData();
                    if (!format.toLowerCase().equals(ConfigCoroUtil.mobSpawnsProfile)) break block8;
                    CULog.dbg("detected mob spawns to deserialize by detecting: " + ConfigCoroUtil.mobSpawnsProfile);
                    JsonElement eleTemplates = obj.get("templates");
                    JsonArray arrTemplates = eleTemplates.getAsJsonArray();
                    for (JsonElement eleTemplate : arrTemplates) {
                        JsonArray arr;
                        JsonObject objTemplate = eleTemplate.getAsJsonObject();
                        DataMobSpawnsTemplate template = new DataMobSpawnsTemplate();
                        template.name = objTemplate.get("name").getAsString();
                        if (objTemplate.has("wave_message")) {
                            template.wave_message = objTemplate.get("wave_message").getAsString();
                        }
                        if (objTemplate.has("conditions")) {
                            arr = objTemplate.get("conditions").getAsJsonArray();
                            template.conditions.addAll(DeserializerAllJson.getArray(arr, DataCondition.class));
                        }
                        arr = objTemplate.get("spawns").getAsJsonArray();
                        for (JsonElement ele : arr) {
                            JsonObject obj2 = ele.getAsJsonObject();
                            DataActionMobSpawns spawnTemplate = DeserializerAllJson.deserializeSpawns(obj2);
                            template.spawns.add(spawnTemplate);
                        }
                        data.addMobSpawnTemplate(template);
                    }
                    break block9;
                }
                if (!format.toLowerCase().equals("cmods")) break block10;
                CULog.dbg("detected cmods to deserialize");
                JsonElement eleTemplates = obj.get("templates");
                JsonArray arrTemplates = eleTemplates.getAsJsonArray();
                for (JsonElement eleTemplate : arrTemplates) {
                    JsonObject objTemplate = eleTemplate.getAsJsonObject();
                    DataCmodTemplate template = new DataCmodTemplate();
                    template.name = objTemplate.get("name").getAsString();
                    if (!data.lookupCmodTemplates.containsKey(template.name)) {
                        JsonArray arrCmods = objTemplate.get("cmods").getAsJsonArray();
                        template.cmods.addAll(DeserializerAllJson.getArray(arrCmods, DataCmod.class));
                        data.addCmodTemplate(template.name, template);
                        continue;
                    }
                    CoroUtil.dbg("WARNING: duplicate cmod template name! " + template.name);
                }
                break block9;
            }
            if (!format.toLowerCase().equals("conditions")) break block9;
            CULog.dbg("detected conditions to deserialize");
            JsonElement eleTemplates = obj.get("templates");
            JsonArray arrTemplates = eleTemplates.getAsJsonArray();
            for (JsonElement eleTemplate : arrTemplates) {
                JsonObject objTemplate = eleTemplate.getAsJsonObject();
                DataConditionTemplate template = new DataConditionTemplate();
                template.name = objTemplate.get("name").getAsString();
                if (!data.lookupConditionTemplates.containsKey(template.name)) {
                    JsonArray arrCmods = objTemplate.get("conditions").getAsJsonArray();
                    template.conditions.addAll(DeserializerAllJson.getArray(arrCmods, DataCondition.class));
                    data.addConditionTemplate(template.name, template);
                    continue;
                }
                CoroUtil.dbg("WARNING: duplicate condition template name! " + template.name);
            }
        }
        return data;
    }

    public static DataActionMobSpawns deserializeSpawns(JsonObject json) {
        DataActionMobSpawns spawnTemplate = new DataActionMobSpawns();
        spawnTemplate.count = json.get("count").getAsInt();
        if (json.has("count_max")) {
            spawnTemplate.count_max = json.get("count_max").getAsInt();
        }
        if (json.has("count_difficulty_multiplier")) {
            spawnTemplate.count_difficulty_multiplier = json.get("count_difficulty_multiplier").getAsDouble();
        }
        if (json.has("spawn_type")) {
            String spawnType = json.get("spawn_type").getAsString();
            if (spawnType.equals("ground")) {
                spawnTemplate.spawnType = EnumSpawnPlacementType.GROUND;
            } else if (spawnType.equals("surface")) {
                spawnTemplate.spawnType = EnumSpawnPlacementType.SURFACE;
            } else if (spawnType.equals("cave")) {
                spawnTemplate.spawnType = EnumSpawnPlacementType.CAVE;
            } else if (spawnType.equals("air")) {
                spawnTemplate.spawnType = EnumSpawnPlacementType.AIR;
            } else if (spawnType.equals("water")) {
                spawnTemplate.spawnType = EnumSpawnPlacementType.WATER;
            }
        }
        JsonArray arr2 = json.get("entities").getAsJsonArray();
        Iterator it2 = arr2.iterator();
        while (it2.hasNext()) {
            spawnTemplate.entities.add(((JsonElement)it2.next()).getAsString());
        }
        if (json.has("cmods")) {
            JsonArray arr3 = json.get("cmods").getAsJsonArray();
            spawnTemplate.cmods.addAll(DeserializerAllJson.getArray(arr3, DataCmod.class));
        }
        return spawnTemplate;
    }

    public static JsonObject serializeSpawns(DataActionMobSpawns spawns) {
        JsonObject obj = new JsonObject();
        obj.addProperty("count", (Number)spawns.count);
        obj.addProperty("count_max", (Number)spawns.count_max);
        obj.addProperty("count_difficulty_multiplier", (Number)spawns.count_difficulty_multiplier);
        obj.addProperty("spawnType", spawns.spawnType.name().toLowerCase());
        JsonArray arr1 = new JsonArray();
        for (String str : spawns.entities) {
            arr1.add((JsonElement)new JsonPrimitive(str));
        }
        obj.add("entities", (JsonElement)arr1);
        obj.add("cmods", (JsonElement)DeserializerAllJson.serializeCmods(spawns.cmods));
        return obj;
    }

    public static JsonArray serializeCmods(List<DataCmod> cmods) {
        JsonArray arr2 = new JsonArray();
        for (DataCmod cmod : cmods) {
            if (cmod instanceof CmodInventoryDifficultyScaled) {
                JsonElement ele = ((CmodInventoryDifficultyScaled)cmod).serialize(null, null, null);
                arr2.add((JsonElement)ele.getAsJsonObject());
                continue;
            }
            arr2.add((JsonElement)new JsonParser().parse(new Gson().toJson((Object)cmod, (Type)DifficultyDataReader.lookupJsonNameToCmodDeserializer.get(cmod.cmod))).getAsJsonObject());
        }
        return arr2;
    }

    public static List<DataCmod> deserializeCmods(String json) {
        JsonArray array = new JsonParser().parse(json).getAsJsonArray();
        return DeserializerAllJson.getArray(array, DataCmod.class);
    }

    public static <T> List<T> getArray(JsonArray arr, Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        for (JsonElement ele : arr) {
            Object cmod;
            String name;
            JsonObject obj = ele.getAsJsonObject();
            if (obj.has("condition")) {
                name = obj.get("condition").getAsString();
                if (!DifficultyDataReader.lookupJsonNameToConditionDeserializer.containsKey(name)) continue;
                cmod = (DataCondition)new Gson().fromJson((JsonElement)obj, DifficultyDataReader.lookupJsonNameToConditionDeserializer.get(name));
                list.add(clazz.cast(cmod));
                continue;
            }
            if (!obj.has("cmod") || !DifficultyDataReader.lookupJsonNameToCmodDeserializer.containsKey(name = obj.get("cmod").getAsString())) continue;
            try {
                if (name.equals(UtilEntityBuffs.dataEntityBuffed_InventoryDifficultyScaled)) {
                    cmod = new CmodInventoryDifficultyScaled();
                    ((DataCmod)cmod).cmod = UtilEntityBuffs.dataEntityBuffed_InventoryDifficultyScaled;
                    JsonArray stages = obj.getAsJsonArray("stages");
                    for (JsonElement stage : stages) {
                        CmodInventoryEntry entry = new CmodInventoryEntry();
                        entry.min = stage.getAsJsonObject().get("min").getAsDouble();
                        entry.max = stage.getAsJsonObject().get("max").getAsDouble();
                        entry.inventory = (CmodInventory)new Gson().fromJson((JsonElement)stage.getAsJsonObject(), CmodInventory.class);
                        entry.inventory.cmod = UtilEntityBuffs.dataEntityBuffed_Inventory;
                        ((CmodInventoryDifficultyScaled)cmod).listInventories.add(entry);
                    }
                } else {
                    cmod = (DataCmod)new Gson().fromJson((JsonElement)obj, DifficultyDataReader.lookupJsonNameToCmodDeserializer.get(name));
                }
                list.add(clazz.cast(cmod));
            }
            catch (Exception ex) {
                CULog.err("critical error deserializing " + name);
                ex.printStackTrace();
            }
        }
        return list;
    }

    public static List<DataCondition> getConditionFlattened(DataCondition condition) {
        ArrayList<DataCondition> list = new ArrayList<DataCondition>();
        list.add(condition);
        return DeserializerAllJson.getConditionsFlattened(list);
    }

    public static List<DataCondition> getConditionsFlattened(List<DataCondition> conditions) {
        HashMap<String, DataCondition> lookup = new HashMap<String, DataCondition>();
        for (DataCondition condition : conditions) {
            if (condition instanceof ConditionTemplateReference) continue;
            if (!lookup.containsKey(condition.condition)) {
                lookup.put(condition.condition, condition);
                continue;
            }
            CoroUtil.dbg("duplicate key for condition at top level " + condition.condition);
        }
        for (DataCondition condition : conditions) {
            if (!(condition instanceof ConditionTemplateReference)) continue;
            DataConditionTemplate template = DifficultyDataReader.getData().lookupConditionTemplates.get(((ConditionTemplateReference)condition).template);
            if (template != null) {
                for (DataCondition condition2 : template.conditions) {
                    if (condition2 instanceof ConditionTemplateReference) continue;
                    if (!lookup.containsKey(condition2.condition)) {
                        lookup.put(condition2.condition, condition2);
                        continue;
                    }
                    CoroUtil.dbg("duplicate key for condition from template " + condition2.condition);
                }
                continue;
            }
            CoroUtil.dbg("warning, could not find condition template named " + ((ConditionTemplateReference)condition).template);
        }
        ArrayList<DataCondition> list = new ArrayList<DataCondition>();
        list.addAll(lookup.values());
        return list;
    }

    public static List<DataCmod> getCmodFlattened(DataCmod cmod) {
        ArrayList<DataCmod> list = new ArrayList<DataCmod>();
        list.add(cmod);
        return DeserializerAllJson.getCmodsFlattened(list);
    }

    public static List<DataCmod> getCmodsFlattened(List<DataCmod> cmods) {
        HashMap<String, DataCmod> lookup = new HashMap<String, DataCmod>();
        for (DataCmod cmod : cmods) {
            if (cmod instanceof CmodTemplateReference) continue;
            if (!lookup.containsKey(cmod.cmod)) {
                lookup.put(cmod.cmod, cmod);
                continue;
            }
            CoroUtil.dbg("duplicate key for cmod at top level " + cmod.cmod);
        }
        for (DataCmod cmod : cmods) {
            if (!(cmod instanceof CmodTemplateReference)) continue;
            DataCmodTemplate template = DifficultyDataReader.getData().lookupCmodTemplates.get(((CmodTemplateReference)cmod).template);
            if (template != null) {
                for (DataCmod cmod2 : template.cmods) {
                    if (cmod2 instanceof CmodTemplateReference) continue;
                    if (!lookup.containsKey(cmod2.cmod)) {
                        lookup.put(cmod2.cmod, cmod2);
                        continue;
                    }
                    CoroUtil.dbg("duplicate key for cmod from template " + cmod2.cmod);
                }
                continue;
            }
            CoroUtil.dbg("warning, could not find cmod template named " + ((CmodTemplateReference)cmod).template);
        }
        ArrayList<DataCmod> list = new ArrayList<DataCmod>();
        list.addAll(lookup.values());
        return list;
    }
}

