/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.util;

import CoroUtil.ability.Ability;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class CoroUtilAbility {
    public static NBTTagCompound nbtSyncWriteAbility(String abilityName, ConcurrentHashMap<String, Ability> abilities, boolean fullSync) {
        NBTTagCompound nbt = new NBTTagCompound();
        Ability ability = abilities.get(abilityName);
        if (ability != null) {
            nbt = CoroUtilAbility.nbtSyncWriteAbility(ability, fullSync);
        } else {
            System.out.println("Error: failed to find ability to sync: " + abilityName);
        }
        return nbt;
    }

    public static NBTTagCompound nbtSyncWriteAbility(Ability ability, boolean fullSync) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (fullSync) {
            nbt.func_74782_a(ability.name, (NBTBase)ability.nbtSave());
        } else {
            nbt.func_74782_a(ability.name, (NBTBase)ability.nbtSyncWrite());
        }
        return nbt;
    }

    public static NBTTagCompound nbtSyncWriteAbilities(ConcurrentHashMap<String, Ability> abilities) {
        return CoroUtilAbility.nbtWriteAbilities(abilities, true);
    }

    public static NBTTagCompound nbtSaveAbilities(ConcurrentHashMap<String, Ability> abilities) {
        return CoroUtilAbility.nbtWriteAbilities(abilities, false);
    }

    public static NBTTagCompound nbtWriteAbilities(ConcurrentHashMap<String, Ability> abilities, boolean syncOnly) {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Map.Entry<String, Ability> entry : abilities.entrySet()) {
            if (syncOnly) {
                nbt.func_74782_a(entry.getValue().name, (NBTBase)entry.getValue().nbtSyncWrite());
                continue;
            }
            nbt.func_74782_a(entry.getValue().name, (NBTBase)entry.getValue().nbtSave());
        }
        return nbt;
    }

    public static void nbtLoadSkills(NBTTagCompound nbt, ConcurrentHashMap<String, Ability> abilities, EntityLivingBase owner) {
        CoroUtilAbility.nbtLoadSkills(nbt, abilities, owner, false);
    }

    public static void nbtLoadSkills(NBTTagCompound nbt, ConcurrentHashMap<String, Ability> abilities, EntityLivingBase owner, boolean syncOnly) {
        for (String tagName : nbt.func_150296_c()) {
            NBTTagCompound data = (NBTTagCompound)nbt.func_74781_a(tagName);
            String abilityName = data.func_74779_i("name");
            Ability ability = null;
            if (syncOnly) {
                ability = abilities.get(abilityName);
            }
            boolean abilityWasMissing = false;
            if (ability == null) {
                ability = CoroUtilAbility.createAbilityFromString(data.func_74779_i("classname"));
                abilityWasMissing = true;
            }
            if (ability != null) {
                ability.init(owner);
                if (abilityWasMissing || !syncOnly) {
                    if (data.func_74767_n("fullSave")) {
                        ability.nbtLoad(data);
                    } else {
                        System.out.println("Abilities error: code tried to do a full nbt load but one is not available, implementation error - " + owner);
                    }
                }
                if (syncOnly) {
                    ability.nbtSyncRead(data);
                }
                if (abilities.contains(abilityName)) continue;
                abilities.put(abilityName, ability);
                continue;
            }
            System.out.println("critical error reading skill from nbt/list");
        }
    }

    public static Ability createAbilityFromString(String parFullClassName) {
        try {
            Class<?> createClass = Class.forName(parFullClassName);
            Constructor<?> constructor = createClass.getConstructor(new Class[0]);
            Object createObject = constructor.newInstance(new Object[0]);
            if (createObject instanceof Ability) {
                return (Ability)createObject;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

