/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.util;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.InvalidBlockStateException;
import net.minecraft.command.NumberInvalidException;

public class CoroUtilBlockState {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').trimResults();
    private static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2).trimResults();

    public static IBlockState getStatelessBlock(Block block) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        return new StateImplementationImpl(block, builder.build());
    }

    public static boolean partialStateInListMatchesFullState(IBlockState fullState, List<IBlockState> listStates) {
        for (IBlockState partialState : listStates) {
            if (!CoroUtilBlockState.partialStateMatchesFullState(partialState, fullState)) continue;
            return true;
        }
        return false;
    }

    public static boolean partialStateMatchesFullState(IBlockState partialState, IBlockState fullState) {
        if (partialState.func_177230_c() != fullState.func_177230_c()) {
            return false;
        }
        for (IProperty prop : partialState.func_177228_b().keySet()) {
            if (partialState.func_177229_b(prop) == fullState.func_177229_b(prop)) continue;
            return false;
        }
        return true;
    }

    public static IBlockState convertArgToBlockState(Block p_190794_0_, String p_190794_1_) throws NumberInvalidException, InvalidBlockStateException {
        return CommandBase.func_190794_a((Block)p_190794_0_, (String)p_190794_1_);
    }

    public static IBlockState convertArgToPartialBlockState(Block p_190794_0_, String p_190794_1_) throws NumberInvalidException, InvalidBlockStateException {
        try {
            int i = Integer.parseInt(p_190794_1_);
            if (i < 0) {
                throw new NumberInvalidException("commands.generic.num.tooSmall", new Object[]{i, 0});
            }
            if (i > 15) {
                throw new NumberInvalidException("commands.generic.num.tooBig", new Object[]{i, 15});
            }
            return p_190794_0_.func_176203_a(Integer.parseInt(p_190794_1_));
        }
        catch (RuntimeException var7) {
            try {
                Map<IProperty<?>, Comparable<?>> map = CoroUtilBlockState.getBlockStatePropertyValueMap(p_190794_0_, p_190794_1_);
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry<IProperty<?>, Comparable<?>> entry : map.entrySet()) {
                    builder.put(entry.getKey(), entry.getValue());
                }
                StateImplementationImpl iblockstate = new StateImplementationImpl(p_190794_0_, builder.build());
                return iblockstate;
            }
            catch (RuntimeException var6) {
                throw new InvalidBlockStateException("commands.generic.blockstate.invalid", new Object[]{p_190794_1_, Block.field_149771_c.func_177774_c((Object)p_190794_0_)});
            }
        }
    }

    private static Map<IProperty<?>, Comparable<?>> getBlockStatePropertyValueMap(Block p_190795_0_, String p_190795_1_) throws InvalidBlockStateException {
        HashMap map = Maps.newHashMap();
        if ("default".equals(p_190795_1_)) {
            return p_190795_0_.func_176223_P().func_177228_b();
        }
        BlockStateContainer blockstatecontainer = p_190795_0_.func_176194_O();
        Iterator iterator = COMMA_SPLITTER.split((CharSequence)p_190795_1_).iterator();
        while (true) {
            Object comparable;
            IProperty iproperty;
            if (!iterator.hasNext()) {
                return map;
            }
            String s = (String)iterator.next();
            Iterator iterator1 = EQUAL_SPLITTER.split((CharSequence)s).iterator();
            if (!iterator1.hasNext() || (iproperty = blockstatecontainer.func_185920_a((String)iterator1.next())) == null || !iterator1.hasNext() || (comparable = CoroUtilBlockState.getValueHelper(iproperty, (String)iterator1.next())) == null) break;
            map.put(iproperty, comparable);
        }
        throw new InvalidBlockStateException("commands.generic.blockstate.invalid", new Object[]{p_190795_1_, Block.field_149771_c.func_177774_c((Object)p_190795_0_)});
    }

    private static <T extends Comparable<T>> IBlockState getBlockState(IBlockState p_190793_0_, IProperty<T> p_190793_1_, Comparable<?> p_190793_2_) {
        return p_190793_0_.func_177226_a(p_190793_1_, p_190793_2_);
    }

    @Nullable
    private static <T extends Comparable<T>> T getValueHelper(IProperty<T> p_190792_0_, String p_190792_1_) {
        return (T)((Comparable)p_190792_0_.func_185929_b(p_190792_1_).orNull());
    }

    public static class StateImplementationImpl
    extends BlockStateContainer.StateImplementation {
        protected StateImplementationImpl(Block blockIn, ImmutableMap<IProperty<?>, Comparable<?>> propertiesIn) {
            super(blockIn, propertiesIn);
        }
    }
}

