/*
 * Decompiled with CFR 0.152.
 */
package modconfig.gui;

import CoroUtil.forge.CULog;
import modconfig.ConfigEntryInfo;
import modconfig.ConfigMod;
import modconfig.ModConfigData;
import modconfig.forge.PacketHelper;
import modconfig.gui.GuiConfigScrollPanel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiConfigEditor
extends GuiScreen {
    public int ySize;
    public int xSize;
    public int xOffset;
    public static int G_RESET = 0;
    public static int G_SAVE = 1;
    public static int G_MODNEXT = 2;
    public static int G_MODPREV = 3;
    public static int G_CONFIGMODE = 4;
    public static int G_CLOSE = 9;
    public static int curIndex = 0;
    public GuiConfigScrollPanel scrollPane;
    public static boolean clientMode = false;
    public ResourceLocation resGUI = new ResourceLocation("modconfig:textures/gui/gui512.png");

    public GuiConfigEditor() {
        this.field_146297_k = Minecraft.func_71410_x();
    }

    public ModConfigData getConfigData(String modID) {
        ModConfigData data = ConfigMod.configLookup.get(modID);
        return data;
    }

    public String getCategory() {
        if (ConfigMod.liveEditConfigs.size() <= 0) {
            return "<NULL>";
        }
        return ConfigMod.liveEditConfigs.get((int)GuiConfigEditor.curIndex).configID;
    }

    public ModConfigData getData() {
        return this.getConfigData(this.getCategory());
    }

    public void func_73876_c() {
        try {
            this.updateStates();
            if (ConfigMod.liveEditConfigs.size() > 0) {
                for (int i = 0; i < this.getData().configData.size(); ++i) {
                    if (this.getData().configData.get((int)i).editBox == null || !this.getData().configData.get((int)i).editBox.isFocused()) continue;
                    this.getData().configData.get((int)i).editBox.updateCursorCounter();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.func_73876_c();
    }

    public void func_73863_a(int var1, int var2, float var3) {
        try {
            int startX = (this.field_146294_l - this.xSize) / 2;
            int startY = (this.field_146295_m - this.ySize) / 2;
            this.drawGuiContainerBackgroundLayer(0.0f, 0, 0);
            this.scrollPane.drawScreen(var1, var2, var3);
            this.drawGuiContainerClippingScrollLayer(0.0f, 0, 0);
            this.func_73731_b(this.field_146289_q, "Config for: " + this.getCategory(), startX + 10, startY + 10, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, curIndex + 1 + "/" + ConfigMod.liveEditConfigs.size(), startX + this.xSize - 60, startY + 10, 0xFFFFFF);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.func_73863_a(var1, var2, var3);
    }

    protected void drawGuiContainerClippingScrollLayer(float var1, int var2, int var3) {
        int startX = 4 + (this.field_146294_l - this.xSize) / 2;
        int startY = 4 + (this.field_146295_m - this.ySize) / 2;
        int x1 = this.xSize - 8;
        int y1 = startY;
        int y2 = startY + 23;
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        vertexbuffer.func_181662_b((double)startX + (double)x1, (double)y1, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        vertexbuffer.func_181662_b((double)startX, (double)y1, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        vertexbuffer.func_181662_b((double)startX, (double)y2, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        vertexbuffer.func_181662_b((double)startX + (double)x1, (double)y2, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        tessellator.func_78381_a();
        y1 = startY + this.ySize - 14 - 23;
        y2 = startY + this.ySize - 14;
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        vertexbuffer.func_181662_b((double)startX + (double)x1, (double)y1, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        vertexbuffer.func_181662_b((double)startX, (double)y1, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        vertexbuffer.func_181662_b((double)startX, (double)y2, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        vertexbuffer.func_181662_b((double)startX + (double)x1, (double)y2, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
    }

    protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3) {
        this.xSize = 256;
        this.ySize = 256;
        this.xSize = 372;
        this.ySize = 250;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.resGUI);
        int startX = (this.field_146294_l - this.xSize) / 2;
        int startY = (this.field_146295_m - this.ySize) / 2;
        this.func_73729_b(startX, startY, 0, 0, 512, 512);
    }

    public boolean func_73868_f() {
        return true;
    }

    public void updateChangedValues() {
        for (int i = 0; i < this.getData().configData.size(); ++i) {
            ConfigEntryInfo info = this.getData().configData.get(i);
            if (this.getData().configData.get((int)i).editBox.text.equals(this.getData().configData.get((int)i).value.toString())) continue;
            if (!clientMode) {
                ConfigMod.eventChannel.sendToServer(PacketHelper.getModConfigPacketForClientToServer("set " + this.getCategory() + " " + this.getData().configData.get((int)i).name + " " + this.getData().configData.get((int)i).editBox.text));
                continue;
            }
            if (!ConfigMod.updateField(this.getCategory(), this.getData().configData.get((int)i).name, this.getData().configData.get((int)i).editBox.text)) continue;
            CULog.dbg("Updated config settings in client mode");
        }
    }

    public void func_73866_w_() {
        this.xSize = 372;
        this.ySize = 250;
        int startX = (this.field_146294_l - this.xSize) / 2;
        int startY = (this.field_146295_m - this.ySize) / 2;
        ScaledResolution var8 = new ScaledResolution(this.field_146297_k);
        int scaledWidth = var8.func_78326_a();
        int scaledHeight = var8.func_78328_b();
        this.scrollPane = new GuiConfigScrollPanel(this, this.field_146297_k, startX, startY, startY + this.ySize - 50, 20);
        this.scrollPane.registerScrollButtons(null, 7, 8);
        if (!clientMode) {
            this.field_146297_k.field_71439_g.func_71165_d("/config update " + this.getCategory());
        } else {
            ConfigMod.populateData(this.getCategory());
        }
        int buttonWidth = 90;
        int buttonHeight = 20;
        int paddingSize = 8;
        int navWidth = 20;
        int navHeight = 20;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(G_MODPREV, startX + this.xSize - (navWidth + 22) * 2, startY + paddingSize - 3, navWidth, navHeight, "<"));
        this.field_146292_n.add(new GuiButton(G_MODNEXT, startX + this.xSize - (navWidth + paddingSize) * 1, startY + paddingSize - 3, navWidth, navHeight, ">"));
        this.field_146292_n.add(new GuiButton(G_SAVE, startX + this.xSize - (buttonWidth + paddingSize) * 2, startY + this.ySize - buttonHeight - paddingSize, buttonWidth, buttonHeight, "Save"));
        this.field_146292_n.add(new GuiButton(G_CLOSE, startX + this.xSize - (buttonWidth + paddingSize) * 1, startY + this.ySize - buttonHeight - paddingSize, buttonWidth, buttonHeight, "Close"));
        if (this.field_146297_k.func_71356_B()) {
            clientMode = false;
        } else {
            this.field_146292_n.add(new GuiButton(G_CONFIGMODE, startX + this.xSize - (buttonWidth + paddingSize) * 3, startY + this.ySize - buttonHeight - paddingSize, buttonWidth, buttonHeight, "Mode: " + (clientMode ? "Local" : "Remote")));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void func_73869_a(char par1, int par2) {
        try {
            if (!this.scrollPane.keyTyped(par1, par2)) return;
            super.func_73869_a(par1, par2);
            if (par1 != '\r') return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        try {
            super.func_73864_a(par1, par2, par3);
            this.scrollPane.mouseClicked(par1, par2, par3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void func_146284_a(GuiButton var1) {
        if (var1.field_146127_k != G_RESET) {
            if (var1.field_146127_k == G_MODPREV) {
                if (--curIndex < 0) {
                    curIndex = ConfigMod.liveEditConfigs.size() - 1;
                }
            } else if (var1.field_146127_k == G_MODNEXT) {
                if (++curIndex >= ConfigMod.liveEditConfigs.size()) {
                    curIndex = 0;
                }
            } else if (var1.field_146127_k == G_SAVE) {
                this.updateChangedValues();
            } else if (var1.field_146127_k == G_CONFIGMODE) {
                clientMode = !clientMode;
            } else if (var1.field_146127_k == G_CLOSE) {
                this.field_146297_k.func_147108_a((GuiScreen)null);
                this.field_146297_k.func_71381_h();
            }
        }
        this.func_73866_w_();
    }

    public void updateStates() {
        GuiButton var22 = null;
        for (GuiButton var22 : this.field_146292_n) {
        }
    }

    public void func_73729_b(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.001953125f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + height) * f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + 0) * f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f)).func_181675_d();
        tessellator.func_78381_a();
    }
}

