/*
 * Decompiled with CFR 0.152.
 */
package com.github.blitzsy.dwarvenproc.command;

import com.github.blitzsy.dwarvenproc.reference.Types;
import com.github.blitzsy.dwarvenproc.util.ProcUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerSelector;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;

public class DwarvenProcCommands
implements ICommand {
    public String func_71517_b() {
        return Types.Commands.Aliases.PROC_COMMAND_ALIASES.get(0);
    }

    public List func_71514_a() {
        return Types.Commands.Aliases.PROC_COMMAND_ALIASES;
    }

    public String func_71518_a(ICommandSender sender) {
        return this.func_71517_b() + " help";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("help")) {
                this.displayCommandHelp(sender);
            } else if (args[0].equalsIgnoreCase("item")) {
                this.displayCommandItemInfo(sender, args);
            } else if (args[0].equalsIgnoreCase("give")) {
                this.performCommandProc(sender, args);
            } else {
                this.displayHelpErrorMessage(sender);
            }
        } else {
            this.displayHelpErrorMessage(sender);
        }
    }

    private void displayHelpErrorMessage(ICommandSender sender) {
        sender.func_145747_a(new ChatComponentTranslation("dwarvenproc.command.helpBadInput", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
    }

    private void displayCommandHelp(ICommandSender sender) {
        sender.func_145747_a(new ChatComponentTranslation("dwarvenproc.command.help.header", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.WHITE)));
        sender.func_145747_a(new ChatComponentTranslation("dwarvenproc.command.help.infoitem", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN)));
        sender.func_145747_a(new ChatComponentTranslation("dwarvenproc.command.help.infogive", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN)));
    }

    private void displayCommandItemInfo(ICommandSender sender, String[] args) {
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            ItemStack heldItem = player.func_70694_bm();
            if (heldItem != null) {
                player.func_146105_b(new ChatComponentTranslation("dwarvenproc.command.item.infoheader", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.WHITE)));
                player.func_146105_b(new ChatComponentTranslation("dwarvenproc.command.item.weaponnameinfo", new Object[]{" " + EnumChatFormatting.BLUE + heldItem.func_77977_a()}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN)));
                player.func_146105_b(new ChatComponentTranslation("dwarvenproc.command.item.displaynameinfo", new Object[]{" " + EnumChatFormatting.BLUE + heldItem.func_82833_r()}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN)));
            } else {
                sender.func_145747_a(new ChatComponentTranslation("dwarvenproc.command.item.noitemheld", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
            }
        } else {
            sender.func_145747_a(new ChatComponentTranslation("dwarvenproc.command.notIngame", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
        }
    }

    private void performCommandProc(ICommandSender sender, String[] args) {
        if (args.length == 2) {
            String playerName = args[1].trim().toLowerCase();
            List<EntityPlayer> entities = playerName.startsWith("@") ? PlayerSelector.func_179656_b((ICommandSender)sender, (String)args[1], EntityLivingBase.class) : Arrays.asList(ProcUtils.findPlayerByName(args[1]));
            if (entities != null && entities.size() > 0) {
                for (EntityPlayer entityObj : entities) {
                    if (entityObj == null || !(entityObj instanceof EntityLivingBase)) continue;
                    EntityLivingBase entity = (EntityLivingBase)entityObj;
                    ProcUtils.giveEntityProc(entity);
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)entity;
                    player.func_145747_a(new ChatComponentTranslation("dwarvenproc.command.give.other", new Object[]{EnumChatFormatting.WHITE + sender.func_70005_c_()}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN)));
                }
            }
        } else if (sender instanceof EntityPlayer) {
            ProcUtils.giveEntityProc((EntityLivingBase)((EntityPlayer)sender));
            sender.func_145747_a(new ChatComponentTranslation("dwarvenproc.command.give.self", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN)));
        } else {
            sender.func_145747_a(new ChatComponentTranslation("dwarvenproc.command.notIngame", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
        }
    }

    private List getPlayerTabCompletes(String tabCompletetion) {
        String tabComplete = tabCompletetion.trim().toLowerCase();
        String[] users = MinecraftServer.func_71276_C().func_71203_ab().func_72369_d();
        if (tabComplete.length() == 0) {
            return Arrays.asList(users);
        }
        ArrayList<String> players = new ArrayList<String>();
        for (String user : users) {
            if (!user.toLowerCase().startsWith(tabComplete)) continue;
            players.add(user);
        }
        return players;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getCommandTabCompletion(String tabCompletion) {
        String tabComplete = tabCompletion.trim().toLowerCase();
        if (tabComplete.length() == 0) {
            return Types.Commands.SubCommands.PROC_SUB_COMMANDS;
        }
        ArrayList<String> completions = new ArrayList<String>();
        List<String> list = Types.Commands.SubCommands.PROC_SUB_COMMANDS;
        synchronized (list) {
            for (String subCommand : Types.Commands.SubCommands.PROC_SUB_COMMANDS) {
                if (!subCommand.startsWith(tabComplete)) continue;
                completions.add(subCommand);
            }
        }
        return completions;
    }

    public boolean func_71519_b(ICommandSender sender) {
        return sender.func_70003_b(4, this.func_71517_b());
    }

    public List func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return this.getCommandTabCompletion(args[0]);
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("give")) {
            return this.getPlayerTabCompletes(args[1]);
        }
        return null;
    }

    public boolean func_82358_a(String[] sender, int index) {
        return false;
    }

    public int compareTo(ICommand o) {
        return this.func_71517_b().compareTo(o.func_71517_b());
    }
}

