/*
 * Decompiled with CFR 0.152.
 */
package com.github.blitzsy.dwarvenproc.configuration;

import com.github.blitzsy.dwarvenproc.reference.Settings;
import java.io.File;
import java.util.Arrays;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationSettings {
    private Configuration configuration;

    public ConfigurationSettings(File configurationFile) {
        this.configuration = new Configuration(configurationFile);
        this.loadConfiguration();
    }

    private void loadConfiguration() {
        this.configuration.load();
        Settings.Config.allowAnyProcItem = this.configuration.getBoolean("AllowAnyProcItem", "Restrictions", Settings.Config.allowAnyProcItem, "Setting this to true will allow any item to produce a proc. This setting does not affect AllowAnyItemName.");
        Settings.Config.allowAnyItemName = this.configuration.getBoolean("AllowAnyItemName", "Restrictions", Settings.Config.allowAnyItemName, "Setting this to true will allow a item to not require to be renamed to produce a proc. This setting does not affect AllowAnyProcItem");
        Settings.Config.allowBowProc = this.configuration.getBoolean("AllowBowProc", "Restrictions", Settings.Config.allowBowProc, "Setting this to false will not allow a player to gain a proc using a ranged weapon such as a bow.");
        Settings.Config.allowReverseBowProc = this.configuration.getBoolean("AllowReverseBowProc", "Restrictions", Settings.Config.allowReverseBowProc, "Setting this to false will not allow a player to kill entities using a proc with a ranged weapon such as a bow.");
        Settings.Config.allowPlayerVsPlayerProc = this.configuration.getBoolean("AllowPlayerVsPlayerProc", "Restrictions", Settings.Config.allowPlayerVsPlayerProc, "Setting this to true will allow a player to gain procs off players and kill other players with a proc.");
        Settings.Config.allowProcingMobs = this.configuration.getBoolean("AllowProcingMobs", "Restrictions", Settings.Config.allowProcingMobs, "Setting this to true will allow mobs to gain a proc using a weapon capable of procing.");
        Settings.Config.procItemNames = Arrays.asList(this.configuration.getStringList("ProcItemNames", "Proc", Settings.Config.procItemNames.toArray(new String[Settings.Config.procItemNames.size()]), "This is a list of names that a item can be renamed to enable it to produce a proc, You can get a item by its name by using the /proc item command."));
        Settings.Config.procItemTypes = Arrays.asList(this.configuration.getStringList("ProcItemTypes", "Proc", Settings.Config.procItemTypes.toArray(new String[Settings.Config.procItemTypes.size()]), "This is a list of unlocalized item names which can produce a proc, You can get a item by its name by using the /proc item command."));
        Settings.Config.displayProcKillCount = this.configuration.getBoolean("DisplayProcKillCount", "Proc", Settings.Config.displayProcKillCount, "Setting this to true will enable the kill streak chat message after a proc has worn off.");
        if (this.configuration.hasChanged()) {
            this.configuration.save();
        }
    }
}

