/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.backup;

import myencyclopedia.common.config.XMLConfigFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigBackup
extends XMLConfigFile {
    public static final String CONFIG_BACKUP = "ConfigBackup.xml";
    public static final String BACKUP_PATH = "/myencyclopedia/backup/path";
    public static final String OPTION_LANG = "/myencyclopedia/backup/option/language";
    public static final String OPTION_NO_CONFIRM = "/myencyclopedia/backup/option/noconfirm";
    private static ConfigBackup theInstance = null;
    private static final Logger logger = LoggerFactory.getLogger(ConfigBackup.class);

    private ConfigBackup() throws XMLConfigFile.ConfigMismatchException {
        super(CONFIG_BACKUP);
    }

    public static ConfigBackup initInstance() {
        if (theInstance == null) {
            try {
                theInstance = new ConfigBackup();
            }
            catch (XMLConfigFile.ConfigMismatchException ex) {
                logger.error("", (Throwable)ex);
                System.exit(-1);
            }
        } else {
            System.err.println("Already have called ConfigBackup initInstance");
            System.exit(-1);
        }
        return theInstance;
    }

    public static ConfigBackup getInstance() {
        if (theInstance == null) {
            System.err.println("Need to call ConfigBackup initInstance");
            System.exit(-1);
        }
        return theInstance;
    }

    public String getPath() {
        return this.getNodeValue(BACKUP_PATH);
    }

    public String getLanguage() {
        return this.getNodeValue(OPTION_LANG);
    }

    public boolean isConfirmDisallowed() {
        return Boolean.parseBoolean(this.getNodeValue(OPTION_NO_CONFIRM));
    }
}

