/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.backup.syncfolder;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ResourceBundle;
import myencyclopedia.common.interf.Confirmer;
import myencyclopedia.common.utils.HashUtil;
import myencyclopedia.logic.backup.ConfigBackup;
import myencyclopedia.logic.backup.syncfolder.SyncResult;
import myencyclopedia.logic.backup.task.ResultSubscriber;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncFolder {
    private static final Logger logger = LoggerFactory.getLogger(SyncFolder.class);
    private ResultSubscriber subscriber;
    private boolean confirmUpdateExisting;
    private Confirmer confirmer;
    private boolean hasError;
    private boolean noUserConfirm = false;
    private boolean md5Check;
    protected static ResourceBundle rb = ResourceBundle.getBundle("properties.logic-backup");

    public SyncFolder(ResultSubscriber subscriber, boolean confirmUpdateExisting, Confirmer confirmer, boolean md5Check) {
        this.subscriber = subscriber;
        this.confirmUpdateExisting = confirmUpdateExisting;
        this.confirmer = confirmer;
        this.noUserConfirm = ConfigBackup.getInstance().isConfirmDisallowed();
        this.md5Check = md5Check;
    }

    public boolean sync(File sourceFolder, File targetFolder) {
        this.hasError = false;
        if (!sourceFolder.exists() || sourceFolder.isFile()) {
            SyncFolder.dispatchResult(this.subscriber, false, sourceFolder, rb.getString("SyncFolder.NoSrcFolder"));
            return false;
        }
        if (targetFolder.isFile()) {
            SyncFolder.dispatchResult(this.subscriber, false, targetFolder, rb.getString("SyncFolder.TargetIsFile"));
            return false;
        }
        if (!targetFolder.exists()) {
            if (this.noUserConfirm) {
                SyncFolder.dispatchResult(this.subscriber, false, targetFolder, rb.getString("SyncFolder.NoTargetFolder"));
                return false;
            }
            boolean reply = this.confirmer.waitForAnswer(String.format(rb.getString("SyncFolder.CreateTargetDir"), targetFolder.toString()), rb.getString("SyncFolder.CreateTargetDirTitle"), false);
            if (reply) {
                if (!targetFolder.mkdirs()) {
                    SyncFolder.dispatchResult(this.subscriber, false, targetFolder, rb.getString("SyncFolder.CannotCreateTargetDir"));
                    return false;
                }
                SyncFolder.dispatchResult(this.subscriber, true, targetFolder, rb.getString("SyncFolder.CreatedTargetDir"));
            } else {
                SyncFolder.dispatchResult(this.subscriber, false, targetFolder, rb.getString("SyncFolder.NoTargetFolder"));
                return false;
            }
        }
        LinkedList<File> sourceSubFiles = new LinkedList<File>();
        sourceSubFiles.addAll(Arrays.asList(sourceFolder.listFiles()));
        LinkedList<File> targetSubFiles = new LinkedList<File>();
        targetSubFiles.addAll(Arrays.asList(targetFolder.listFiles()));
        while (!sourceSubFiles.isEmpty()) {
            File targetFile;
            File sourceFile = (File)sourceSubFiles.remove(sourceSubFiles.size() - 1);
            if (sourceFile.isFile()) {
                targetFile = SyncFolder.findFile(sourceFile, targetSubFiles);
                if (targetFile == null) {
                    try {
                        targetFile = new File(targetFolder.getCanonicalPath() + File.separator + sourceFile.getName());
                        FileUtils.copyFile((File)sourceFile, (File)targetFile, (boolean)true);
                        SyncFolder.dispatchResult(this.subscriber, true, sourceFile, rb.getString("SyncFolder.Copied_NoTarget"));
                    }
                    catch (IOException ex) {
                        logger.error("", (Throwable)ex);
                        this.hasError = true;
                        SyncFolder.dispatchResult(this.subscriber, false, sourceFile, rb.getString("SyncFolder.FailedToCopy_NoTarget"));
                    }
                    continue;
                }
                if (this.md5Check) {
                    String md5Target;
                    String md5Src;
                    try {
                        md5Src = HashUtil.computeMD5((File)sourceFile);
                        md5Target = HashUtil.computeMD5((File)targetFile);
                    }
                    catch (Exception ex) {
                        logger.error("", (Throwable)ex);
                        SyncFolder.dispatchResult(this.subscriber, false, sourceFile, rb.getString("SyncFolder.FailedToCalcMD5") + ex);
                        continue;
                    }
                    if (md5Target.equals(md5Src)) continue;
                    try {
                        String info;
                        if (this.confirmUpdateExisting && !this.noUserConfirm && !this.confirmer.waitForAnswer(info = String.format(rb.getString("SyncFolder.SizeComparison"), targetFile.toString(), targetFile.length(), sourceFile.toString(), sourceFile.length()), rb.getString("SyncFolder.ConfirmUpdateTitle"), false)) {
                            SyncFolder.dispatchResult(this.subscriber, true, sourceFile, rb.getString("SyncFolder.ConfirmUpdate.IgnoredMd5"));
                            continue;
                        }
                        FileUtils.copyFile((File)sourceFile, (File)targetFile, (boolean)true);
                        SyncFolder.dispatchResult(this.subscriber, true, sourceFile, (this.confirmUpdateExisting ? rb.getString("SyncFolder.ConfirmedThen") : "") + rb.getString("SyncFolder.Copied_MD5"));
                    }
                    catch (IOException ex) {
                        logger.error("", (Throwable)ex);
                        this.hasError = true;
                        SyncFolder.dispatchResult(this.subscriber, false, sourceFile, rb.getString("SyncFolder.FailedToCopy_MD5"));
                    }
                    continue;
                }
                if (!FileUtils.isFileNewer((File)sourceFile, (File)targetFile) && sourceFile.length() == targetFile.length()) continue;
                String reason = null;
                reason = sourceFile.length() != targetFile.length() ? rb.getString("SyncFolder.Reason_SizeUnequal") : rb.getString("SyncFolder.Reason_Older");
                try {
                    String info;
                    if (this.confirmUpdateExisting && !this.noUserConfirm && !this.confirmer.waitForAnswer(info = String.format(rb.getString("SyncFolder.SizeComparison"), targetFile.toString(), targetFile.length(), sourceFile.toString(), sourceFile.length()), rb.getString("SyncFolder.ConfirmUpdateTitle"), false)) {
                        SyncFolder.dispatchResult(this.subscriber, true, sourceFile, rb.getString("SyncFolder.ConfirmUpdate.Ignored") + reason);
                        continue;
                    }
                    FileUtils.copyFile((File)sourceFile, (File)targetFile, (boolean)true);
                    SyncFolder.dispatchResult(this.subscriber, true, sourceFile, (this.confirmUpdateExisting ? rb.getString("SyncFolder.ConfirmedThen") : "") + rb.getString("SyncFolder.Copied") + reason);
                }
                catch (IOException ex) {
                    logger.error("", (Throwable)ex);
                    this.hasError = true;
                    SyncFolder.dispatchResult(this.subscriber, false, sourceFile, rb.getString("SyncFolder.FailedToCopy") + reason);
                }
                continue;
            }
            targetFile = SyncFolder.findFile(sourceFile, targetSubFiles);
            if (targetFile == null) {
                try {
                    targetFile = new File(targetFolder.getCanonicalPath() + File.separator + sourceFile.getName());
                    if (targetFile.mkdir()) {
                        SyncFolder.dispatchResult(this.subscriber, true, targetFile, rb.getString("SyncFolder.Mkdir_NoTarget"));
                        this.sync(sourceFile, targetFile);
                        continue;
                    }
                    throw new IOException("Cannot mkdir");
                }
                catch (IOException ex) {
                    logger.error("", (Throwable)ex);
                    this.hasError = true;
                    SyncFolder.dispatchResult(this.subscriber, false, targetFile, rb.getString("SyncFolder.Mkdir_NoTarget_Failed"));
                    continue;
                }
            }
            this.sync(sourceFile, targetFile);
        }
        while (!targetSubFiles.isEmpty()) {
            String info;
            File targetFile = (File)targetSubFiles.remove(targetSubFiles.size() - 1);
            if (targetFile.isFile()) {
                if (!this.noUserConfirm) {
                    if (this.confirmUpdateExisting) {
                        info = String.format(rb.getString("SyncFolder.TargetSize"), targetFile.toString(), targetFile.length());
                        if (!this.confirmer.waitForAnswer(info, rb.getString("SyncFolder.ConfirmUpdateTitle"), false)) {
                            SyncFolder.dispatchResult(this.subscriber, true, null, rb.getString("SyncFolder.SyncFolder.ConfirmDelete.Ignored"));
                            continue;
                        }
                        if (targetFile.delete()) {
                            SyncFolder.dispatchResult(this.subscriber, true, targetFile, rb.getString("SyncFolder.ConfirmDelete.Done"));
                            continue;
                        }
                        this.hasError = true;
                        SyncFolder.dispatchResult(this.subscriber, false, targetFile, rb.getString("SyncFolder.FailedToDelete"));
                        continue;
                    }
                    if (this.confirmer.waitForAnswerEnableAlways(String.format(rb.getString("SyncFolder.ConfirmDeleteFile"), targetFile.getAbsolutePath()), rb.getString("SyncFolder.ConfirmDelete.Title"), false)) {
                        if (targetFile.delete()) {
                            SyncFolder.dispatchResult(this.subscriber, true, targetFile, rb.getString("SyncFolder.DeletedFile"));
                            continue;
                        }
                        this.hasError = true;
                        SyncFolder.dispatchResult(this.subscriber, false, targetFile, rb.getString("SyncFolder.FailedToDelete"));
                        continue;
                    }
                    SyncFolder.dispatchResult(this.subscriber, true, targetFile, rb.getString("SyncFolder.ConfirmDelete.Reject"));
                    continue;
                }
                if (targetFile.delete()) {
                    SyncFolder.dispatchResult(this.subscriber, true, targetFile, rb.getString("SyncFolder.DeletedFile"));
                    continue;
                }
                this.hasError = true;
                SyncFolder.dispatchResult(this.subscriber, false, targetFile, rb.getString("SyncFolder.FailedToDelete"));
                continue;
            }
            if (!this.noUserConfirm) {
                if (this.confirmUpdateExisting) {
                    info = String.format(rb.getString("SyncFolder.TargetSize"), targetFile.toString(), targetFile.length());
                    if (!this.confirmer.waitForAnswer(info, rb.getString("SyncFolder.ConfirmUpdateTitle"), false)) {
                        SyncFolder.dispatchResult(this.subscriber, true, null, rb.getString("SyncFolder.SyncFolder.ConfirmDelete.Ignored"));
                        continue;
                    }
                    try {
                        FileUtils.deleteDirectory((File)targetFile);
                        SyncFolder.dispatchResult(this.subscriber, true, targetFile, rb.getString("SyncFolder.ConfirmDelete.Done"));
                    }
                    catch (IOException ex) {
                        logger.error("", (Throwable)ex);
                        this.hasError = true;
                        SyncFolder.dispatchResult(this.subscriber, false, targetFile, rb.getString("SyncFolder.FailedToDelete"));
                    }
                    continue;
                }
                if (this.confirmer != null && this.confirmer.waitForAnswerEnableAlways(String.format(rb.getString("SyncFolder.ConfirmDeleteFile"), targetFile.getAbsolutePath()), rb.getString("SyncFolder.ConfirmDelete.Title"), false)) {
                    try {
                        FileUtils.deleteDirectory((File)targetFile);
                        SyncFolder.dispatchResult(this.subscriber, true, targetFile, rb.getString("SyncFolder.DeletedFile"));
                    }
                    catch (IOException ex) {
                        logger.error("", (Throwable)ex);
                        this.hasError = true;
                        SyncFolder.dispatchResult(this.subscriber, false, targetFile, rb.getString("SyncFolder.FailedToDelete"));
                    }
                    continue;
                }
                SyncFolder.dispatchResult(this.subscriber, true, targetFile, rb.getString("SyncFolder.ConfirmDelete.Reject"));
                continue;
            }
            try {
                FileUtils.deleteDirectory((File)targetFile);
                SyncFolder.dispatchResult(this.subscriber, true, targetFile, rb.getString("SyncFolder.DeletedFile"));
            }
            catch (IOException ex) {
                logger.error("", (Throwable)ex);
                this.hasError = true;
                SyncFolder.dispatchResult(this.subscriber, false, targetFile, rb.getString("SyncFolder.FailedToDelete"));
            }
        }
        return !this.hasError;
    }

    private static File findFile(File fileToFound, LinkedList<File> collection) {
        boolean isFile = fileToFound.isFile();
        String name = fileToFound.getName();
        for (File testFile : collection) {
            if (!testFile.getName().equals(name) || testFile.isFile() != isFile) continue;
            collection.remove(testFile);
            return testFile;
        }
        return null;
    }

    private static void dispatchResult(ResultSubscriber subscriber, boolean success, File file, String message) {
        if (subscriber == null) {
            return;
        }
        String fileStr = "";
        try {
            fileStr = file.getCanonicalPath();
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
        }
        SyncResult result = new SyncResult(fileStr, success, message);
        subscriber.onReceive(result);
    }
}

