/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.backup.task;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import myencyclopedia.logic.backup.ConfigBackup;
import myencyclopedia.logic.backup.task.StringResult;
import myencyclopedia.logic.backup.task.Task;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlType(name="CopyFolderTask")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CopyFolderTask
extends Task {
    @XmlElement(name="timestamp_enabled")
    protected boolean isTimestampEnabled;
    private static final Logger logger = LoggerFactory.getLogger(CopyFolderTask.class);
    protected static ResourceBundle rb = ResourceBundle.getBundle("properties.logic-backup");

    public boolean getTimestampEnabled() {
        return this.isTimestampEnabled;
    }

    public void setTimestampEnabled(boolean enableDate) {
        this.isTimestampEnabled = enableDate;
    }

    @Override
    public String getTaskIdentifier() {
        return CopyFolderTask.getIdentifier();
    }

    public static String getIdentifier() {
        return "Copy Folder";
    }

    @Override
    public boolean performTask() {
        try {
            File destFolder;
            File srcFolder = new File(this.getSource());
            File destParentFolder = new File(this.getDestination());
            if (!srcFolder.exists() || srcFolder.isFile()) {
                StringResult result = new StringResult(rb.getString("CopyFolderTask.NoSourceFolder"));
                this.resultSubscriber.onReceive(result);
                return false;
            }
            if (destParentFolder.isFile()) {
                StringResult result = new StringResult(rb.getString("CopyFolderTask.DestinationIsFile"));
                this.resultSubscriber.onReceive(result);
                return false;
            }
            if (!destParentFolder.exists()) {
                if (ConfigBackup.getInstance().isConfirmDisallowed()) {
                    StringResult result = new StringResult(rb.getString("CopyFolderTask.NoDestination"));
                    this.resultSubscriber.onReceive(result);
                    return false;
                }
                boolean answer = this.confirmer.waitForAnswer(String.format(rb.getString("CopyFolderTask.ConfirmCreateFolder"), destParentFolder), rb.getString("WARNING"), true);
                if (!answer || !destParentFolder.mkdirs()) {
                    StringResult result = new StringResult(rb.getString("CopyFolderTask.NoDestination"));
                    this.resultSubscriber.onReceive(result);
                    return false;
                }
            }
            String name = srcFolder.getName();
            if (this.isTimestampEnabled) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss");
                name = name + "-" + formatter.format(new Date());
            }
            if ((destFolder = new File(this.getDestination() + File.separator + name)).exists()) {
                if (destFolder.isFile()) {
                    StringResult result = new StringResult(rb.getString("CopyFolderTask.DestinationIsFile"));
                    this.resultSubscriber.onReceive(result);
                    return false;
                }
                if (ConfigBackup.getInstance().isConfirmDisallowed()) {
                    StringResult result = new StringResult(rb.getString("CopyFolderTask.MergeFolder"));
                    this.resultSubscriber.onReceive(result);
                } else {
                    boolean answer = this.confirmer.waitForAnswer(rb.getString("CopyFolderTask.MergeFolder") + destParentFolder, rb.getString("WARNING"), true);
                    if (!answer) {
                        StringResult result = new StringResult(rb.getString("CopyFolderTask.MergeFolderDenied"));
                        this.resultSubscriber.onReceive(result);
                        return false;
                    }
                }
            }
            FileUtils.copyDirectory((File)srcFolder, (File)destFolder);
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
            StringResult result = new StringResult(ex.getMessage());
            this.resultSubscriber.onReceive(result);
            return false;
        }
        return true;
    }
}

