/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.backup.task;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import myencyclopedia.common.utils.ZipUtil;
import myencyclopedia.logic.backup.ConfigBackup;
import myencyclopedia.logic.backup.task.StringResult;
import myencyclopedia.logic.backup.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlType(name="CpZippedFolderTask")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CpZippedFolderTask
extends Task {
    @XmlElement(name="timestamp_enabled")
    protected boolean isTimestampEnabled;
    private static final Logger logger = LoggerFactory.getLogger(CpZippedFolderTask.class);
    protected static ResourceBundle rb = ResourceBundle.getBundle("properties.logic-backup");

    public boolean getTimestampEnabled() {
        return this.isTimestampEnabled;
    }

    public void setTimestampEnabled(boolean enableDate) {
        this.isTimestampEnabled = enableDate;
    }

    @Override
    public String getTaskIdentifier() {
        return CpZippedFolderTask.getIdentifier();
    }

    public static String getIdentifier() {
        return "Zip & Copy Folder";
    }

    @Override
    public boolean performTask() {
        File srcFolder = new File(this.getSource());
        File destFolder = new File(this.getDestination());
        if (!srcFolder.exists() || srcFolder.isFile()) {
            StringResult result = new StringResult(rb.getString("CopyFolderTask.NoSourceFolder"));
            this.resultSubscriber.onReceive(result);
            return false;
        }
        if (destFolder.isFile()) {
            StringResult result = new StringResult(rb.getString("CopyFolderTask.DestinationIsFile"));
            this.resultSubscriber.onReceive(result);
            return false;
        }
        if (!destFolder.exists()) {
            if (ConfigBackup.getInstance().isConfirmDisallowed()) {
                StringResult result = new StringResult(rb.getString("CopyFolderTask.NoDestination"));
                this.resultSubscriber.onReceive(result);
                return false;
            }
            boolean answer = this.confirmer.waitForAnswer(rb.getString("CopyFolderTask.ConfirmCreateFolder") + destFolder, rb.getString("WARNING"), true);
            if (!answer || !destFolder.mkdirs()) {
                StringResult result = new StringResult(rb.getString("CopyFolderTask.NoDestination"));
                this.resultSubscriber.onReceive(result);
                return false;
            }
        }
        String fileNameSuffix = "";
        if (this.isTimestampEnabled) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss");
            fileNameSuffix = "-" + dateFormat.format(new Date());
        }
        String zipFileName = this.getDestination() + File.separator + srcFolder.getName() + fileNameSuffix + ".zip";
        try {
            ZipUtil.zipFile((File)srcFolder, (File)new File(zipFileName));
            return true;
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            StringResult result = new StringResult(ex.getMessage());
            this.resultSubscriber.onReceive(result);
            return false;
        }
    }
}

