/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.backup.task;

import java.util.Iterator;
import java.util.List;
import myencyclopedia.common.interf.Confirmer;
import myencyclopedia.logic.backup.task.IGUIEventChannel;
import myencyclopedia.logic.backup.task.Result;
import myencyclopedia.logic.backup.task.ResultSubscriber;
import myencyclopedia.logic.backup.task.Task;
import myencyclopedia.logic.backup.task.TaskThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorThread
extends Thread
implements ResultSubscriber {
    private List<Task> tasks;
    private IGUIEventChannel guiEventDispatcher;
    private volatile boolean isCancelled;
    private volatile Task activeTask;
    private Confirmer confirmer;
    private static final Logger logger = LoggerFactory.getLogger(MonitorThread.class);

    public MonitorThread(List<Task> tasks, IGUIEventChannel guiEventDispatcher, Confirmer confirmer) {
        this.confirmer = confirmer;
        this.tasks = tasks;
        this.guiEventDispatcher = guiEventDispatcher;
    }

    @Override
    public synchronized void run() {
        this.guiEventDispatcher.dispatch(IGUIEventChannel.GlobalEvent.START);
        Iterator<Task> iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            Task task;
            this.activeTask = task = iterator.next();
            TaskThread taskThread = new TaskThread(this, this.activeTask);
            this.guiEventDispatcher.dispatch(this.activeTask, IGUIEventChannel.TaskEvent.START, null);
            taskThread.start();
            try {
                this.wait();
                if (this.isCancelled) {
                    this.guiEventDispatcher.dispatch(this.activeTask, IGUIEventChannel.TaskEvent.INTERRUPTED, null);
                    taskThread.stop();
                    break;
                }
            }
            catch (InterruptedException ex) {
                logger.error("", (Throwable)ex);
            }
            if (taskThread.getResult()) {
                this.guiEventDispatcher.dispatch(this.activeTask, IGUIEventChannel.TaskEvent.FINISHED, null);
                continue;
            }
            this.guiEventDispatcher.dispatch(this.activeTask, IGUIEventChannel.TaskEvent.FAIL, null);
        }
        this.guiEventDispatcher.dispatch(IGUIEventChannel.GlobalEvent.FINISH);
    }

    public synchronized void cancellAll() {
        this.isCancelled = true;
        this.notify();
    }

    public synchronized void taskFinished() {
        this.notify();
    }

    public static void main(String[] args) {
    }

    @Override
    public void onReceive(Result result) {
        this.guiEventDispatcher.dispatch(this.activeTask, IGUIEventChannel.TaskEvent.MESSAGE, result);
    }
}

