/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.backup.task;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import myencyclopedia.logic.backup.ConfigBackup;
import myencyclopedia.logic.backup.task.GroupTask;
import myencyclopedia.logic.backup.task.RootElement;
import myencyclopedia.logic.backup.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManager {
    private static TaskManager theTaskManager = null;
    private static RootElement rootElement = null;
    private static JAXBContext context;
    private static final Logger logger;
    private static final String CONFIG_NAME = "Tasks.xml";
    private static final File CONFIG_FILE;
    private static int nextId;
    private static boolean inited;
    private static GroupTask defaultGroup;
    protected static ResourceBundle rb;

    private TaskManager() {
    }

    public static void init() throws JAXBException {
        inited = true;
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{RootElement.class});
        }
        catch (JAXBException ex) {
            logger.error("cannot init JAXBContext", (Throwable)ex);
            System.exit(-1);
        }
        if (!CONFIG_FILE.exists()) {
            TaskManager.createEmptyConfig();
            return;
        }
        Unmarshaller u = context.createUnmarshaller();
        rootElement = (RootElement)u.unmarshal((Source)new StreamSource(CONFIG_FILE));
        for (GroupTask g : rootElement.getGroups()) {
            if ("0".equals(g.getId())) {
                defaultGroup = g;
            }
            for (Task t : g.getTasks()) {
                String taskId = t.id;
                t.setParent(g);
                try {
                    Integer id = Integer.parseInt(taskId);
                    nextId = id + 1;
                }
                catch (Exception ex) {
                    logger.error("parse id error", (Throwable)ex);
                }
            }
        }
    }

    public GroupTask getDefaultGroup() {
        return defaultGroup;
    }

    public static void createEmptyConfig() throws JAXBException {
        nextId = 0;
        rootElement = new RootElement();
        defaultGroup = new GroupTask();
        defaultGroup.setName(rb.getString("GROUP_DEFAULT"));
        defaultGroup.setId();
        rootElement.addGroup(defaultGroup);
        TaskManager.persist();
    }

    public static TaskManager getTaskManager() {
        if (!inited) {
            System.err.println("TaskManager.init() should be called");
            System.exit(-1);
        }
        if (theTaskManager == null) {
            theTaskManager = new TaskManager();
        }
        return theTaskManager;
    }

    public RootElement getRootElement() {
        return rootElement;
    }

    public void deleteGroup(GroupTask t) {
        rootElement.getGroups().remove(t);
    }

    public static String generateId() {
        String ret = String.valueOf(nextId);
        ++nextId;
        return ret;
    }

    public static void persist() throws JAXBException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(CONFIG_FILE);
        }
        catch (FileNotFoundException ex) {
            logger.error("", (Throwable)ex);
        }
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)rootElement, (OutputStream)fileOutputStream);
    }

    static {
        logger = LoggerFactory.getLogger(TaskManager.class);
        CONFIG_FILE = new File(ConfigBackup.getInstance().getPath(), CONFIG_NAME);
        inited = false;
        rb = ResourceBundle.getBundle("properties.logic-backup");
    }
}

