/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.backup.task.execproc;

import java.io.IOException;
import java.util.List;
import myencyclopedia.logic.backup.task.ResultSubscriber;
import myencyclopedia.logic.backup.task.execproc.ExecResult;
import myencyclopedia.logic.backup.task.execproc.StreamGobbler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exec {
    private static final Logger logger = LoggerFactory.getLogger(Exec.class);

    public static boolean start(List<String> cmdList, ResultSubscriber subscriber) {
        block5: {
            try {
                ProcessBuilder pb = new ProcessBuilder(cmdList);
                Process proc = pb.start();
                StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), subscriber, ExecResult.OutputType.STDERR);
                StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), subscriber, ExecResult.OutputType.STDOUT);
                errorGobbler.start();
                outputGobbler.start();
                int exitVal = proc.waitFor();
                if (subscriber != null) {
                    subscriber.onReceive(new ExecResult(ExecResult.OutputType.EXIT_CODE, String.valueOf(exitVal)));
                }
                logger.debug("process finished:" + exitVal);
                return exitVal == 0;
            }
            catch (IOException ex) {
                logger.error("unexpected cmd error", (Throwable)ex);
                if (subscriber != null) {
                    subscriber.onReceive(new ExecResult(ExecResult.OutputType.EXCEPTION, ex.toString()));
                }
            }
            catch (InterruptedException ex) {
                logger.error("interrupted exception", (Throwable)ex);
                if (subscriber == null) break block5;
                subscriber.onReceive(new ExecResult(ExecResult.OutputType.EXCEPTION, ex.toString()));
            }
        }
        return false;
    }
}

