/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.help;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import myencyclopedia.common.gui.LaunchUtils;
import myencyclopedia.common.utils.LocaleUtil;
import myencyclopedia.gui.help.AutoUpdateUtil;
import myencyclopedia.gui.help.LicenseManager;
import myencyclopedia.gui.help.LicenseStage;
import myencyclopedia.gui.help.ProductInfo;
import myencyclopedia.gui.help.SendMessageUtil;
import myencyclopedia.gui.help.VersionStage;

public class MenuItemFactory {
    public static ResourceBundle rb = ResourceBundle.getBundle("properties.gui-help");

    public static Menu createMenu(ProductInfo productInfo) {
        Menu menuHelp = new Menu(rb.getString("MENU_HELP"));
        menuHelp.setMnemonicParsing(true);
        MenuItem mVersion = MenuItemFactory.createVersionMenuItem(productInfo);
        MenuItem mRegister = MenuItemFactory.createRegistryMenuItem(productInfo);
        MenuItem mManual = MenuItemFactory.createManualMenuItem(productInfo);
        MenuItem mContactme = MenuItemFactory.createContactMeMenuItem(productInfo);
        MenuItem mAutoUpdate = MenuItemFactory.createAutoUpdateMenuItem(productInfo);
        menuHelp.getItems().addAll((Object[])new MenuItem[]{mManual, mAutoUpdate, mContactme});
        if (!LicenseManager.getLicenseManager().isRegistered()) {
            menuHelp.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), mRegister, new SeparatorMenuItem()});
        }
        menuHelp.getItems().add((Object)mVersion);
        return menuHelp;
    }

    public static MenuItem createVersionMenuItem(ProductInfo productInfo) {
        VersionStage versionStage = new VersionStage(productInfo);
        MenuItem mVersion = new MenuItem(rb.getString("MENU_VERSION"));
        mVersion.setMnemonicParsing(true);
        mVersion.setOnAction(t -> versionStage.showAndWait());
        return mVersion;
    }

    public static MenuItem createManualMenuItem(ProductInfo productInfo) {
        MenuItem mManual = new MenuItem(rb.getString("MENU_MANUAL"));
        mManual.setOnAction(t -> {
            Path manualHtml = Paths.get("manual", productInfo.getProductName(), LocaleUtil.getStringValue(), "index.html");
            LaunchUtils.openFileWithDefaultApp((Path)manualHtml);
        });
        return mManual;
    }

    public static MenuItem createContactMeMenuItem(ProductInfo productInfo) {
        MenuItem mContact = new MenuItem(rb.getString("MENU_CONTACT"));
        mContact.setOnAction(t -> SendMessageUtil.showStage(productInfo));
        return mContact;
    }

    public static MenuItem createAutoUpdateMenuItem(ProductInfo productInfo) {
        MenuItem mAutoUpdate = new MenuItem(rb.getString("MENU_CHECK_UPDATE"));
        mAutoUpdate.setOnAction(t -> AutoUpdateUtil.showStage(productInfo));
        return mAutoUpdate;
    }

    public static MenuItem createRegistryMenuItem(ProductInfo productInfo) {
        MenuItem mRegister = new MenuItem(rb.getString("MENU_REGISTER"));
        mRegister.setOnAction(t -> {
            LicenseStage licenseStage = new LicenseStage();
            licenseStage.showAndWait();
        });
        return mRegister;
    }
}

