/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.progress;

import myencyclopedia.common.progress.Logic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancellableLogicRunnable
implements Runnable {
    private Logic logic;
    private volatile boolean cancelled = false;
    private static final Logger logger = LoggerFactory.getLogger(CancellableLogicRunnable.class);
    private LogicStage logicStage = LogicStage.Prepare;

    public CancellableLogicRunnable(Logic logic) {
        this.logic = logic;
    }

    @Override
    public void run() {
        try {
            while (!this.cancelled || this.logicStage != LogicStage.ExitLoop) {
                switch (this.logicStage) {
                    case Prepare: {
                        boolean hasMore = this.logic.prepare();
                        this.logic.dispatchProgressEvent();
                        if (hasMore) {
                            this.logicStage = LogicStage.StepProgress;
                            break;
                        }
                        return;
                    }
                    case StepProgress: {
                        if (this.logic.hasNextStep()) {
                            this.logic.step();
                            this.logic.dispatchProgressEvent();
                            break;
                        }
                        this.logicStage = LogicStage.CleanUp;
                        break;
                    }
                    case CleanUp: {
                        this.logic.cleanUp();
                        this.logic.dispatchProgressEvent();
                        this.logicStage = LogicStage.ExitLoop;
                    }
                }
                if (this.logicStage != LogicStage.ExitLoop) continue;
                break;
            }
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
    }

    public void cancel() {
        this.cancelled = true;
    }

    private static enum LogicStage {
        Prepare,
        StepProgress,
        CleanUp,
        ExitLoop;

    }
}

