/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;

public class FileCopyUtil {
    static void copyFile(Path source, Path target, boolean preserve) throws IOException {
        CopyOption[] copyOptionArray;
        if (preserve) {
            CopyOption[] copyOptionArray2 = new CopyOption[2];
            copyOptionArray2[0] = StandardCopyOption.COPY_ATTRIBUTES;
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[1] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            CopyOption[] copyOptionArray3 = new CopyOption[1];
            copyOptionArray = copyOptionArray3;
            copyOptionArray3[0] = StandardCopyOption.REPLACE_EXISTING;
        }
        CopyOption[] options = copyOptionArray;
        if (Files.notExists(target, new LinkOption[0])) {
            Files.copy(source, target, options);
        }
    }

    public static void copy(Path source, Path target) throws IOException {
        boolean isDir = Files.isDirectory(target, new LinkOption[0]);
        Path dest = isDir ? target.resolve(source.getFileName()) : target;
        TreeCopier tc = new TreeCopier(source, dest, true);
        Files.walkFileTree(source, tc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        BufferedInputStream inBuff = null;
        FilterOutputStream outBuff = null;
        try {
            int len;
            inBuff = new BufferedInputStream(in);
            outBuff = new BufferedOutputStream(out);
            byte[] b = new byte[5120];
            while ((len = inBuff.read(b)) != -1) {
                ((BufferedOutputStream)outBuff).write(b, 0, len);
            }
            ((BufferedOutputStream)outBuff).flush();
        }
        finally {
            if (inBuff != null) {
                inBuff.close();
            }
            if (outBuff != null) {
                outBuff.close();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        Path source = Paths.get("C:\\temp\\tightvnc-jviewer.jar", new String[0]);
        Path target = Paths.get("C:\\my.jar", new String[0]);
        FileCopyUtil.copy(source, target);
    }

    static class TreeCopier
    implements FileVisitor<Path> {
        private final Path source;
        private final Path target;
        private final boolean preserve;

        TreeCopier(Path source, Path target, boolean preserve) {
            this.source = source;
            this.target = target;
            this.preserve = preserve;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            CopyOption[] copyOptionArray;
            if (this.preserve) {
                CopyOption[] copyOptionArray2 = new CopyOption[1];
                copyOptionArray = copyOptionArray2;
                copyOptionArray2[0] = StandardCopyOption.COPY_ATTRIBUTES;
            } else {
                copyOptionArray = new CopyOption[]{};
            }
            CopyOption[] options = copyOptionArray;
            Path newdir = this.target.resolve(this.source.relativize(dir));
            try {
                Files.copy(dir, newdir, options);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException x) {
                throw x;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            FileCopyUtil.copyFile(file, this.target.resolve(this.source.relativize(file)), this.preserve);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (exc == null && this.preserve) {
                Path newdir = this.target.resolve(this.source.relativize(dir));
                FileTime time = Files.getLastModifiedTime(dir, new LinkOption[0]);
                Files.setLastModifiedTime(newdir, time);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            throw exc;
        }
    }
}

