/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.DirectoryChooser;

public class InputGridPane
extends GridPane {
    private int nextRowIdx = 0;
    private Map<String, TextField> mapTextField = new HashMap<String, TextField>();
    private Map<String, Set<Control>> mapControl = new HashMap<String, Set<Control>>();
    public static ResourceBundle rb = ResourceBundle.getBundle("properties.gui-common");

    public InputGridPane() {
        ColumnConstraints column1 = new ColumnConstraints();
        ColumnConstraints column2 = new ColumnConstraints(100.0);
        ColumnConstraints column3 = new ColumnConstraints();
        column1.setFillWidth(true);
        column2.setHgrow(Priority.ALWAYS);
        column2.setFillWidth(true);
        column3.setHgrow(Priority.ALWAYS);
        column3.setFillWidth(true);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2, column3});
        this.setHgap(10.0);
        this.setVgap(10.0);
    }

    public TextField nextDir(String labelStr, String initialValue) {
        return this.nextItem(labelStr, initialValue, true);
    }

    public TextField nextText(String labelStr, String initialValue) {
        return this.nextItem(labelStr, initialValue, false);
    }

    public void setDisabled(String labelStr, boolean disabled) {
        Set<Control> controlSet = this.mapControl.get(labelStr);
        for (Control c : controlSet) {
            c.setDisable(disabled);
        }
    }

    public String getValueFor(String labelStr) {
        TextField input = this.mapTextField.get(labelStr);
        if (input != null) {
            return input.getText();
        }
        return null;
    }

    public void setValueFor(String labelStr, String value) {
        TextField input = this.mapTextField.get(labelStr);
        if (input != null) {
            input.setText(value);
        }
    }

    private TextField nextItem(String labelStr, String initialValue, boolean isDir) {
        Label txt = new Label(labelStr);
        this.add((Node)txt, 0, this.nextRowIdx);
        final TextField input = new TextField();
        if (initialValue != null) {
            input.setText(initialValue);
        }
        HashSet<Object> controlSet = new HashSet<Object>();
        controlSet.add(txt);
        controlSet.add(input);
        this.mapControl.put(labelStr, controlSet);
        this.mapTextField.put(labelStr, input);
        if (isDir) {
            Button btn = new Button(rb.getString("SELECT"));
            controlSet.add(btn);
            this.add((Node)input, 2, this.nextRowIdx);
            this.add((Node)btn, 1, this.nextRowIdx);
            btn.setOnAction(new EventHandler(){

                public void handle(Event event) {
                    DirectoryChooser dirChooser = new DirectoryChooser();
                    File folder = dirChooser.showDialog(null);
                    if (folder != null) {
                        try {
                            input.setText(folder.getCanonicalPath());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        } else {
            this.add((Node)input, 1, this.nextRowIdx, 2, 1);
        }
        ++this.nextRowIdx;
        return input;
    }
}

