/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui;

import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;

public class StageUtils {
    public static void addDragListeners(final Stage stage) {
        final StageUtilsInfo info = new StageUtilsInfo();
        final Scene scene = stage.getScene();
        scene.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getX() > stage.getWidth() - 10.0 && event.getX() < stage.getWidth() + 10.0) {
                    info.resizebottom = true;
                    scene.setCursor(Cursor.H_RESIZE);
                    info.dx = stage.getWidth() - event.getX();
                } else {
                    info.resizebottom = false;
                    scene.setCursor(Cursor.MOVE);
                    info.initialX = event.getSceneX();
                    info.initialY = event.getSceneY();
                }
            }
        });
        scene.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                scene.setCursor(Cursor.DEFAULT);
            }
        });
        scene.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (!info.resizebottom.booleanValue()) {
                    stage.setX(event.getScreenX() - info.initialX);
                    stage.setY(event.getScreenY() - info.initialY);
                } else {
                    stage.setWidth(event.getX() + info.dx);
                }
            }
        });
        scene.setOnMouseDragReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                scene.setCursor(Cursor.DEFAULT);
            }
        });
    }

    static class StageUtilsInfo {
        double initialY;
        double initialX;
        Boolean resizebottom = false;
        double dx;

        StageUtilsInfo() {
        }
    }
}

