/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui;

import java.util.ArrayList;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.util.Callback;

public class TreeTableRetainFixedColumnResizePolicy
implements Callback<TreeTableView.ResizeFeatures, Boolean> {
    double mTVWidth;

    public Boolean call(TreeTableView.ResizeFeatures arg0) {
        TreeTableView tv = arg0.getTable();
        Double tvWidth = tv.widthProperty().getValue();
        if (tvWidth == null || tvWidth <= 0.0) {
            return false;
        }
        if (this.mTVWidth != tvWidth && arg0.getColumn() == null) {
            this.mTVWidth = tvWidth;
            int numColsToSize = 0;
            double fixedColumnsWidths = 0.0;
            for (TreeTableColumn col : new ArrayList(tv.getColumns())) {
                if (col.isResizable() && col.isVisible()) {
                    ++numColsToSize;
                    continue;
                }
                if (!col.isVisible()) continue;
                fixedColumnsWidths += col.getWidth();
            }
            if (numColsToSize == 0) {
                return (Boolean)TreeTableView.UNCONSTRAINED_RESIZE_POLICY.call((Object)arg0);
            }
            TreeTableColumn lastCol = null;
            for (TreeTableColumn col : new ArrayList(tv.getColumns())) {
                if (!col.isResizable() || !col.isVisible()) continue;
                double newWidth = (tvWidth - fixedColumnsWidths) / (double)numColsToSize;
                col.setPrefWidth(newWidth);
                lastCol = col;
            }
            if (lastCol != null) {
                lastCol.setPrefWidth(lastCol.getPrefWidth() - 2.0);
            }
            return true;
        }
        return (Boolean)TreeTableView.UNCONSTRAINED_RESIZE_POLICY.call((Object)arg0);
    }
}

