/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.progress;

import javafx.concurrent.Task;
import myencyclopedia.common.progress.Logic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancellableLogicTask
extends Task<Void> {
    private Logic logic;
    private static final Logger logger = LoggerFactory.getLogger(CancellableLogicTask.class);
    private LogicStage logicStage = LogicStage.Prepare;

    public CancellableLogicTask(Logic logic) {
        this.logic = logic;
    }

    protected Void call() throws Exception {
        try {
            while (!this.isCancelled() && this.logicStage != LogicStage.ExitLoop) {
                switch (this.logicStage) {
                    case Prepare: {
                        boolean hasMore = this.logic.prepare();
                        this.logic.dispatchProgressEvent();
                        if (hasMore) {
                            this.logicStage = LogicStage.StepProgress;
                            break;
                        }
                        return null;
                    }
                    case StepProgress: {
                        if (this.logic.hasNextStep()) {
                            this.logic.step();
                            this.logic.dispatchProgressEvent();
                            break;
                        }
                        this.logicStage = LogicStage.CleanUp;
                        break;
                    }
                    case CleanUp: {
                        this.logic.cleanUp();
                        this.logic.dispatchProgressEvent();
                        this.logicStage = LogicStage.ExitLoop;
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            throw ex;
        }
        return null;
    }

    public boolean stop() {
        return this.cancel(false);
    }

    private static enum LogicStage {
        Prepare,
        StepProgress,
        CleanUp,
        ExitLoop;

    }
}

