/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.progress;

import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.common.gui.progress.CancellableLogicTask;
import myencyclopedia.common.progress.Logic;
import myencyclopedia.common.progress.LogicEvent;
import myencyclopedia.common.progress.LogicListener;

public abstract class ProgressPane
extends VBox
implements LogicListener {
    protected Button cancelButton;
    protected ProgressBar progressBar;
    protected Label output;
    protected Label additionLabel;
    protected Label elapsedLabel;
    protected volatile long startingMillis = -1L;
    protected Thread timerThread;
    protected CancellableLogicTask logicTask;
    protected GUIListener processor;
    public static final String EVENT_CANCELLED = "cancel";
    public static final String EVENT_FINISHED = "finish";

    public ProgressPane(GUIListener processor) {
        this.processor = processor;
        HBox progressBarAndCancelBtn = new HBox();
        this.progressBar = new ProgressBar();
        this.cancelButton = new Button("Cancel");
        this.cancelButton.setOnAction(e -> this.cancelLogic());
        progressBarAndCancelBtn.getChildren().addAll((Object[])new Node[]{this.progressBar, this.cancelButton});
        this.output = new Label("Not started");
        this.additionLabel = new Label("Not started");
        this.elapsedLabel = new Label("Elapsed time:");
        this.getChildren().addAll((Object[])new Node[]{progressBarAndCancelBtn, this.output, this.additionLabel, this.elapsedLabel});
        this.startingMillis = System.currentTimeMillis();
        this.timerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        if (ProgressPane.this.startingMillis != -1L) {
                            ProgressPane.this.updateElapsedTime();
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        });
        this.timerThread.start();
    }

    public void resetStartingTime() {
    }

    private void updateElapsedTime() {
        long millis = System.currentTimeMillis() - this.startingMillis;
        final StringBuilder txt = new StringBuilder("Elapsed time: ");
        long hour = (millis /= 1000L) / 3600L;
        long minute = (millis %= 3600L) / 60L;
        long second = millis % 60L;
        if (hour != 0L) {
            txt.append(hour).append("h  ");
        }
        if (minute != 0L) {
            txt.append(minute).append("m  ");
        }
        txt.append(second).append("s");
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgressPane.this.elapsedLabel.setText(txt.toString());
            }
        });
    }

    public void runLogic(Logic logic) {
        logic.addIEventNotifier((LogicListener)this);
        this.logicTask = new CancellableLogicTask(logic);
        new Thread((Runnable)((Object)this.logicTask)).start();
        this.resetStartingTime();
    }

    public void cancelLogic() {
        this.logicTask.stop();
        if (this.processor != null) {
            GUIEvent cancelEvent = new GUIEvent(ProgressPane.class, EVENT_CANCELLED, null);
            this.processor.dispatch(cancelEvent);
        }
        this.cancelButton.setDisable(true);
        this.progressBar.setProgress(0.0);
        this.timerThread.interrupt();
    }

    public void dispatch(final LogicEvent event) {
        if (event.getEventName().equals("ProgressUpdate")) {
            Integer percent = (Integer)event.getValue();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                }
            });
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (event.getEventName().equals("FinishCleanup")) {
                        ProgressPane.this.cancelButton.setDisable(true);
                        ProgressPane.this.output.setText("Done");
                        ProgressPane.this.progressBar.setProgress(1.0);
                        ProgressPane.this.timerThread.interrupt();
                        if (ProgressPane.this.processor != null) {
                            GUIEvent finishEvent = new GUIEvent(ProgressPane.class, ProgressPane.EVENT_FINISHED, null);
                            ProgressPane.this.processor.dispatch(finishEvent);
                        }
                    } else if (event.getEventName().equals("StartPreparing")) {
                        ProgressPane.this.output.setText("Start preparing");
                    }
                    ProgressPane.this.handleEventOnGThread(event);
                }
            });
        }
    }

    public abstract void handleEventOnGThread(LogicEvent var1);
}

