/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.backup;

import java.util.ResourceBundle;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.Modality;
import javafx.stage.WindowEvent;
import myencyclopedia.common.gui.TemplateStage;
import myencyclopedia.logic.backup.ConfigBackup;

public class BackupConfigStage
extends TemplateStage {
    private boolean mute;
    private CheckBox chkMute;
    private ConfigBackup config;
    ResourceBundle rb = ResourceBundle.getBundle("properties.gui-backup");
    private ComboBox comboLang;
    private String optionLang;

    public BackupConfigStage() {
        this.initModality(Modality.APPLICATION_MODAL);
        this.config = ConfigBackup.getInstance();
        this.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
            }
        });
        GridPane gridPane = new GridPane();
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        gridPane.setPadding(new Insets(10.0, 10.0, 0.0, 10.0));
        this.chkMute = new CheckBox(this.rb.getString("OPTION_GLOBAL_MUTE"));
        this.comboLang = new ComboBox();
        this.comboLang.getItems().addAll(new Object[]{"English", "\u4e2d\u6587"});
        Label lblLang = new Label(this.rb.getString("OPTION_LABLE_LANG"));
        HBox lang = new HBox(new Node[]{lblLang, this.comboLang});
        gridPane.add((Node)this.chkMute, 0, 0);
        gridPane.add((Node)lang, 0, 1);
        this.bp.setCenter((Node)gridPane);
        this.setTitle(this.rb.getString("OPTION_TITLE"));
        this.sizeToScene();
    }

    public void display() {
        this.mute = this.config.isConfirmDisallowed();
        this.chkMute.setSelected(this.mute);
        this.optionLang = this.config.getLanguage();
        if ("zh_CN".equals(this.optionLang)) {
            this.comboLang.setValue((Object)"\u4e2d\u6587");
        } else {
            this.comboLang.setValue((Object)"English");
        }
        this.showAndWait();
    }

    protected Object prepareResult() {
        String langValue = (String)this.comboLang.getValue();
        boolean isLangChanged = false;
        switch (langValue) {
            case "\u4e2d\u6587": {
                if (!"en_US".equals(this.optionLang)) break;
                isLangChanged = true;
                this.optionLang = "zh_CN";
                break;
            }
            case "English": {
                if (!"zh_CN".equals(this.optionLang)) break;
                isLangChanged = true;
                this.optionLang = "en_US";
            }
        }
        if (isLangChanged || this.chkMute.isSelected() != this.mute) {
            this.config.setNodeValue("/myencyclopedia/backup/option/language", this.optionLang);
            this.config.setNodeValue("/myencyclopedia/backup/option/noconfirm", String.valueOf(this.chkMute.isSelected()));
            this.mute = this.chkMute.isSelected();
            this.config.writeToFile();
        }
        return true;
    }
}

