/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.backup;

import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextInputDialog;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javax.xml.bind.JAXBException;
import myencyclopedia.common.config.XMLConfigFile;
import myencyclopedia.common.gui.ConfigStage;
import myencyclopedia.common.gui.GUIConfirmer;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.common.gui.LangChoiceStage;
import myencyclopedia.common.interf.Confirmer;
import myencyclopedia.common.utils.JDKVersionUtil;
import myencyclopedia.common.utils.LocaleUtil;
import myencyclopedia.common.utils.SingleProcessUtil;
import myencyclopedia.gui.backup.BackupConfigStage;
import myencyclopedia.gui.backup.BackupTreeTable;
import myencyclopedia.gui.backup.ProgressStage;
import myencyclopedia.gui.backup.TaskStage;
import myencyclopedia.gui.help.LicenseManager;
import myencyclopedia.gui.help.MenuItemFactory;
import myencyclopedia.gui.help.ProductInfo;
import myencyclopedia.logic.backup.ConfigBackup;
import myencyclopedia.logic.backup.task.GroupTask;
import myencyclopedia.logic.backup.task.Task;
import myencyclopedia.logic.backup.task.TaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupMain
extends Application
implements GUIListener {
    private static BackupTreeTable backupTable;
    private MenuBar menuBar;
    static final Logger logger;
    private ProductInfo productInfo;
    private static GUIConfirmer confirmer;
    private static TaskStage newTaskStage;
    protected static ResourceBundle rb;

    private static void initConfig() {
        ConfigBackup conf = ConfigBackup.initInstance();
        if (!conf.exists()) {
            LangChoiceStage langChoice = new LangChoiceStage();
            langChoice.showAndWait();
            rb = ResourceBundle.getBundle("properties.gui-backup");
            ConfigStage cs = new ConfigStage((XMLConfigFile)conf, rb.getString("CONFIGURE"), ResourceBundle.getBundle("properties.config-backup"));
            cs.showAndWait();
            if (cs.getErrorMessage() != null) {
                Alert alert = new Alert(Alert.AlertType.ERROR, cs.getErrorMessage(), new ButtonType[0]);
                alert.showAndWait();
                System.exit(0);
            }
            conf.writeToFile();
            ConfigStage.copyHelp((String)"backup");
        } else {
            LocaleUtil.configLocale((String)conf.getLanguage());
            rb = ResourceBundle.getBundle("properties.gui-backup");
        }
        String path = conf.getPath();
        logger.warn("backup xml list path :" + path);
    }

    public static void main(String[] args) {
        JDKVersionUtil.versionCheckOrExit((int)8, (int)45);
        SingleProcessUtil.acquireOrExit((String)"backup");
        Application.launch((String[])args);
    }

    private void initMenu() {
        this.menuBar = new MenuBar();
        Menu menuFile = new Menu(rb.getString("MENU_FILE"));
        Menu menuHelp = MenuItemFactory.createMenu((ProductInfo)this.productInfo);
        this.menuBar.getMenus().addAll((Object[])new Menu[]{menuFile, menuHelp});
        MenuItem menuItemCreate = new MenuItem(rb.getString("MENU_NEW_TASK"));
        menuItemCreate.setAccelerator(KeyCombination.keyCombination((String)"Ctrl+N"));
        menuItemCreate.setOnAction(e -> this.newTask());
        final MenuItem menuItemDelete = new MenuItem(rb.getString("MENU_DELETE_TASK"));
        menuItemDelete.setOnAction(e -> this.deleteTask());
        final MenuItem menuItemExec = new MenuItem(rb.getString("MENU_EXECUTE"));
        menuItemExec.setOnAction(e -> this.execute());
        MenuItem mNewGroup = new MenuItem(rb.getString("MENU_NEW_GROUP"));
        mNewGroup.setOnAction(e -> this.newGroup());
        MenuItem mConfig = new MenuItem(rb.getString("MENU_OPTION"));
        mConfig.setMnemonicParsing(true);
        mConfig.setOnAction(t -> {
            String lang = ConfigBackup.getInstance().getLanguage();
            BackupConfigStage configStage = new BackupConfigStage();
            configStage.display();
            if (!ConfigBackup.getInstance().getLanguage().equals(lang)) {
                Alert alert = new Alert(Alert.AlertType.WARNING, rb.getString("NEED_TO_RESTART"), new ButtonType[0]);
                alert.showAndWait();
            }
        });
        MenuItem exit = new MenuItem(rb.getString("MENU_EXIT"));
        exit.setOnAction(t -> this.quit());
        menuFile.getItems().addAll((Object[])new MenuItem[]{menuItemCreate, menuItemDelete, menuItemExec, mNewGroup, mConfig, new SeparatorMenuItem(), exit});
        menuFile.setOnShowing((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                menuItemDelete.setDisable(backupTable.getSelectionModel().getSelectedIndex() == -1);
                menuItemExec.setDisable(!backupTable.isAnySelected());
            }
        });
    }

    public void start(Stage primaryStage) {
        BackupMain.initConfig();
        this.productInfo = new ProductInfo("backup");
        LicenseManager.initLicenseManager((ProductInfo)this.productInfo);
        this.initMenu();
        newTaskStage = new TaskStage();
        try {
            TaskManager.init();
        }
        catch (Exception ex) {
            logger.error("Unmarshalling error", (Throwable)ex);
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, rb.getString("UNMARSHALL_ERROR"), new ButtonType[0]);
            alert.showAndWait();
            if (alert.getResult() != ButtonType.OK) {
                System.exit(-1);
                return;
            }
            try {
                TaskManager.createEmptyConfig();
            }
            catch (Exception exx) {
                logger.error("createEmptyConfig", (Throwable)exx);
                System.exit(-1);
            }
        }
        confirmer = new GUIConfirmer();
        backupTable = new BackupTreeTable();
        BorderPane borderPane = new BorderPane();
        BorderPane listPane = new BorderPane();
        listPane.setCenter((Node)backupTable);
        borderPane.setCenter((Node)listPane);
        borderPane.setTop((Node)this.menuBar);
        Scene scene = new Scene((Parent)borderPane, 650.0, 500.0);
        scene.setFill((Paint)Color.LIGHTGRAY);
        primaryStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                BackupMain.this.quit();
                we.consume();
            }
        });
        if (System.getProperty("fakeversion") != null) {
            primaryStage.setTitle("ME-Backup " + System.getProperty("fakeversion"));
        } else {
            primaryStage.setTitle(this.productInfo.getTitle());
        }
        primaryStage.setScene(scene);
        Image icon = new Image(((Object)((Object)this)).getClass().getResourceAsStream("/backup_16.gif"));
        primaryStage.getIcons().add((Object)icon);
        primaryStage.show();
    }

    public static void modifyTask(Task task) {
        if (task instanceof GroupTask) {
            TextInputDialog d = new TextInputDialog(task.getName());
            d.setTitle(rb.getString("TITLE_MODIFY_GROUP_NAME"));
            Optional result = d.showAndWait();
            if (result.isPresent()) {
                task.setName((String)result.get());
            }
        } else {
            Task newTask = newTaskStage.showTask(task);
            backupTable.refreshTask(task, newTask);
        }
    }

    private void quit() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, rb.getString("CONFIRM_QUIT"), new ButtonType[0]);
        alert.showAndWait();
        if (alert.getResult() != ButtonType.OK) {
            return;
        }
        this.save();
        System.exit(0);
    }

    private void newTask() {
        Task t = newTaskStage.showTask();
        if (t != null) {
            t.setId();
            backupTable.addToCurrentGroup(t);
        }
    }

    private void newGroup() {
        TextInputDialog d = new TextInputDialog("");
        d.setTitle(rb.getString("INPUT_NEW_GROUP"));
        Optional result = d.showAndWait();
        if (result.isPresent()) {
            GroupTask group = new GroupTask();
            group.setName((String)result.get());
            group.setId();
            backupTable.addGroup(group);
        }
    }

    private void deleteTask() {
        backupTable.deleteSelectedTask();
    }

    private void execute() {
        List<Task> enabledTasks = backupTable.getSelectedTasks();
        for (Task t : enabledTasks) {
            if (!t.getIsSelected()) continue;
            t.setConfirmer((Confirmer)confirmer);
        }
        ProgressStage ps = new ProgressStage(enabledTasks);
        ps.showIt();
    }

    private void save() {
        TaskManager taskMgr = TaskManager.getTaskManager();
        try {
            taskMgr.persist();
        }
        catch (JAXBException ex) {
            logger.error("", (Throwable)ex);
        }
    }

    public Object dispatch(GUIEvent e) {
        return null;
    }

    static {
        logger = LoggerFactory.getLogger(BackupMain.class);
    }
}

