/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.backup;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.cell.CheckBoxTreeTableCell;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.util.Callback;
import myencyclopedia.common.gui.TreeTableRetainFixedColumnResizePolicy;
import myencyclopedia.gui.backup.BackupMain;
import myencyclopedia.logic.backup.task.GroupTask;
import myencyclopedia.logic.backup.task.RootElement;
import myencyclopedia.logic.backup.task.Task;
import myencyclopedia.logic.backup.task.TaskManager;

public class BackupTreeTable
extends TreeTableView<Task> {
    protected Map<Task, SimpleBooleanProperty> mapSelected = new HashMap<Task, SimpleBooleanProperty>();
    protected Map<Task, TreeItem<Task>> map = new HashMap<Task, TreeItem<Task>>();
    protected Map<String, Task> mapId = new HashMap<String, Task>();
    protected TreeItem<Task> root;
    protected RootElement rootElement = TaskManager.getTaskManager().getRootElement();
    protected static ResourceBundle rb = ResourceBundle.getBundle("properties.gui-backup");

    public BackupTreeTable() {
        this.root = this.createRootNode();
        this.root.setExpanded(true);
        this.setRoot(this.root);
        this.setShowRoot(false);
        this.setEditable(true);
        TreeTableColumn colSelected = new TreeTableColumn("");
        colSelected.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<Task, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TreeTableColumn.CellDataFeatures<Task, Boolean> p) {
                final Task t = (Task)p.getValue().getValue();
                if (BackupTreeTable.this.mapSelected.get(t) == null) {
                    SimpleBooleanProperty prop = new SimpleBooleanProperty(t.getIsSelected());
                    prop.addListener(new ChangeListener(){

                        public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                            t.setIsSelected(((Boolean)newValue).booleanValue());
                            if (t instanceof GroupTask) {
                                for (Task subT : ((GroupTask)t).getTasks()) {
                                    BackupTreeTable.this.mapSelected.get(subT).set(((Boolean)newValue).booleanValue());
                                }
                            }
                        }
                    });
                    BackupTreeTable.this.mapSelected.put(t, prop);
                    return prop;
                }
                return (ObservableValue)BackupTreeTable.this.mapSelected.get(t);
            }
        });
        colSelected.setCellFactory(CheckBoxTreeTableCell.forTreeTableColumn((TreeTableColumn)colSelected));
        colSelected.setEditable(true);
        colSelected.setResizable(false);
        TreeTableColumn colName = new TreeTableColumn(rb.getString("COLUMN_NAME"));
        colName.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<Task, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TreeTableColumn.CellDataFeatures<Task, String> p) {
                Task t = (Task)p.getValue().getValue();
                return new ReadOnlyObjectWrapper((Object)t.getName());
            }
        });
        colName.setEditable(false);
        colName.setCellFactory((Callback)new Callback<TreeTableColumn<Task, String>, TreeTableCell<Task, String>>(){

            public TreeTableCell<Task, String> call(TreeTableColumn<Task, String> p) {
                return new DnDCell();
            }
        });
        TreeTableColumn colType = new TreeTableColumn(rb.getString("COLUMN_TYPE"));
        colType.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<Task, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TreeTableColumn.CellDataFeatures<Task, String> p) {
                Task t = (Task)p.getValue().getValue();
                return new ReadOnlyObjectWrapper((Object)rb.getString(t.getClass().getSimpleName()));
            }
        });
        TreeTableColumn colSource = new TreeTableColumn(rb.getString("COLUMN_SOURCE"));
        colSource.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<Task, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TreeTableColumn.CellDataFeatures<Task, String> p) {
                Task t = (Task)p.getValue().getValue();
                return new ReadOnlyObjectWrapper((Object)t.getSource());
            }
        });
        TreeTableColumn colDest = new TreeTableColumn(rb.getString("COLUMN_DEST"));
        colDest.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<Task, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TreeTableColumn.CellDataFeatures<Task, String> p) {
                Task t = (Task)p.getValue().getValue();
                return new ReadOnlyObjectWrapper((Object)t.getDestination());
            }
        });
        this.getColumns().setAll((Object[])new TreeTableColumn[]{colName, colSelected, colType, colSource, colDest});
        this.setColumnResizePolicy((Callback)new TreeTableRetainFixedColumnResizePolicy());
        this.setSortPolicy((Callback)new Callback<TreeTableView<Task>, Boolean>(){

            public Boolean call(TreeTableView param) {
                return false;
            }
        });
        this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                int idx;
                if (event.getClickCount() == 2 && (idx = BackupTreeTable.this.getSelectionModel().getSelectedIndex()) != -1) {
                    Task task = (Task)((TreeItem)BackupTreeTable.this.getSelectionModel().getSelectedItem()).getValue();
                    BackupMain.modifyTask(task);
                    ((TreeTableColumn)BackupTreeTable.this.getColumns().get(0)).setVisible(false);
                    ((TreeTableColumn)BackupTreeTable.this.getColumns().get(0)).setVisible(true);
                    event.consume();
                }
            }
        });
        this.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ke) {
                TreeItem item;
                if (ke.getCode().equals((Object)KeyCode.OPEN_BRACKET)) {
                    TreeItem item2 = (TreeItem)BackupTreeTable.this.getSelectionModel().getSelectedItem();
                    if (item2 != null) {
                        BackupTreeTable.this.moveUp((TreeItem<Task>)item2);
                    }
                } else if (ke.getCode().equals((Object)KeyCode.CLOSE_BRACKET) && (item = (TreeItem)BackupTreeTable.this.getSelectionModel().getSelectedItem()) != null) {
                    BackupTreeTable.this.moveDown((TreeItem<Task>)item);
                }
            }
        });
    }

    public List<Task> getSelectedTasks() {
        LinkedList<Task> retList = new LinkedList<Task>();
        for (Task t : this.mapSelected.keySet()) {
            if (!t.getIsSelected() || t instanceof GroupTask) continue;
            retList.add(t);
        }
        return retList;
    }

    public boolean isAnySelected() {
        for (Task t : this.mapSelected.keySet()) {
            if (!t.getIsSelected() || t instanceof GroupTask) continue;
            return true;
        }
        return false;
    }

    public void addGroup(GroupTask g) {
        this.root.getChildren().add(this.createNode((Task)g));
        this.rootElement.addGroup(g);
    }

    public void addToCurrentGroup(Task t) {
        TreeItem selectedItem = (TreeItem)this.getSelectionModel().getSelectedItem();
        GroupTask selectedGroup = null;
        if (selectedItem != null) {
            selectedGroup = (Task)selectedItem.getValue();
            if (!(selectedGroup instanceof GroupTask)) {
                selectedItem = selectedItem.getParent();
                selectedGroup = (Task)selectedItem.getValue();
            }
        } else {
            selectedGroup = TaskManager.getTaskManager().getDefaultGroup();
            selectedItem = this.map.get(selectedGroup);
        }
        selectedItem.getChildren().add(this.createNode(t));
        selectedGroup.addTask(t);
    }

    public void refreshTask(Task oldTask, Task newTask) {
        if (oldTask == newTask) {
            TreeItem<Task> oldItem = this.map.get(oldTask);
            this.getSelectionModel().select(oldItem);
        } else {
            TreeItem<Task> oldItem = this.map.get(oldTask);
            TreeItem<Task> parentItem = this.map.get(oldTask.getParent());
            TreeItem<Task> newItem = this.createNode(newTask);
            int idx = parentItem.getChildren().indexOf(oldItem);
            parentItem.getChildren().remove(idx);
            parentItem.getChildren().add(idx, newItem);
            this.getSelectionModel().select(newItem);
        }
    }

    public void deleteSelectedTask() {
        TreeItem item = (TreeItem)this.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        if (item.getValue() instanceof GroupTask) {
            GroupTask g = (GroupTask)item.getValue();
            if (g.getId().equals("0")) {
                Alert alert = new Alert(Alert.AlertType.ERROR, rb.getString("CANNOT_DELETE_DEFAULT"), new ButtonType[0]);
                alert.showAndWait();
                return;
            }
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, rb.getString("MOVE_TO_DEFAULT"), new ButtonType[0]);
            alert.showAndWait();
            if (alert.getResult() != ButtonType.OK) {
                TaskManager.getTaskManager().deleteGroup(g);
                this.root.getChildren().remove((Object)item);
                return;
            }
            this.root.getChildren().remove((Object)item);
            TaskManager.getTaskManager().deleteGroup(g);
            for (Task t : g.getTasks()) {
                TaskManager.getTaskManager().getDefaultGroup().addTask(t);
                ObservableList defaultGroupChildren = this.map.get(TaskManager.getTaskManager().getDefaultGroup()).getChildren();
                TreeItem[] array = (TreeItem[])item.getChildren().toArray((Object[])new TreeItem[0]);
                item.getChildren().clear();
                for (TreeItem it : array) {
                    defaultGroupChildren.add((Object)it);
                }
            }
            return;
        }
        GroupTask g = ((Task)item.getValue()).getParent();
        g.removeTask((Task)item.getValue());
        item.getParent().getChildren().remove((Object)item);
    }

    private TreeItem<Task> createRootNode() {
        GroupTask rootDummyTask = new GroupTask();
        TreeItem node = new TreeItem((Object)rootDummyTask);
        for (GroupTask t : this.rootElement.getGroups()) {
            node.getChildren().add(this.createNode((Task)t));
        }
        this.map.put((Task)rootDummyTask, (TreeItem<Task>)node);
        return node;
    }

    private TreeItem<Task> createNode(Task t) {
        TreeItem node = new TreeItem((Object)t);
        if (t instanceof GroupTask) {
            GroupTask group = (GroupTask)t;
            for (Task tt : group.getTasks()) {
                TreeItem<Task> subItem = this.createNode(tt);
                node.getChildren().add(subItem);
            }
        }
        this.map.put(t, (TreeItem<Task>)node);
        this.mapId.put(t.getId(), t);
        return node;
    }

    private void moveUp(TreeItem<Task> item) {
        Task srcTask = (Task)item.getValue();
        boolean isSrcGroup = srcTask instanceof GroupTask;
        if (isSrcGroup) {
            int srcIdx = this.rootElement.getGroups().indexOf(srcTask);
            if (srcIdx == -1 || srcIdx == 0) {
                return;
            }
            Task destTask = (Task)this.rootElement.getGroups().get(srcIdx - 1);
            this.moveNode(destTask, srcTask, false);
        } else {
            int srcIdx = srcTask.getParent().getTasks().indexOf(srcTask);
            if (srcIdx == -1 || srcIdx == 0) {
                return;
            }
            Task destTask = (Task)srcTask.getParent().getTasks().get(srcIdx - 1);
            this.moveNode(destTask, srcTask, false);
        }
    }

    private void moveDown(TreeItem<Task> item) {
        Task srcTask = (Task)item.getValue();
        boolean isSrcGroup = srcTask instanceof GroupTask;
        if (isSrcGroup) {
            int srcIdx = this.rootElement.getGroups().indexOf(srcTask);
            if (srcIdx == -1 || srcIdx == this.rootElement.getGroups().size() - 1) {
                return;
            }
            Task destTask = (Task)this.rootElement.getGroups().get(srcIdx + 1);
            this.moveNode(srcTask, destTask, true);
        } else {
            int srcIdx = srcTask.getParent().getTasks().indexOf(srcTask);
            if (srcIdx == -1 || srcIdx == srcTask.getParent().getTasks().size() - 1) {
                return;
            }
            Task destTask = (Task)srcTask.getParent().getTasks().get(srcIdx + 1);
            this.moveNode(srcTask, destTask, true);
        }
    }

    public void moveNode(Task srcTask, Task destTask, boolean selectSrc) {
        if (srcTask == destTask) {
            return;
        }
        TreeItem<Task> srcItem = this.map.get(srcTask);
        TreeItem<Task> destItem = this.map.get(destTask);
        boolean isSrcGroup = srcTask instanceof GroupTask;
        boolean isTargetGroup = destTask instanceof GroupTask;
        if (isSrcGroup && isTargetGroup) {
            this.rootElement.getGroups().remove((GroupTask)srcTask);
            int destIdx = this.rootElement.getGroups().indexOf(destTask);
            this.rootElement.getGroups().add(destIdx + 1, (GroupTask)srcTask);
            srcItem.getParent().getChildren().remove(srcItem);
            destItem.getParent().getChildren().add(destIdx + 1, srcItem);
        } else if (!isSrcGroup || isTargetGroup) {
            if (!isSrcGroup && isTargetGroup) {
                srcTask.getParent().removeTask(srcTask);
                ((GroupTask)destTask).addTask(0, srcTask);
                srcItem.getParent().getChildren().remove(srcItem);
                destItem.getChildren().add(0, srcItem);
                destItem.setExpanded(true);
            } else {
                srcTask.getParent().removeTask(srcTask);
                int destIdx = destTask.getParent().getTasks().indexOf(destTask);
                destTask.getParent().addTask(destIdx + 1, srcTask);
                srcItem.getParent().getChildren().remove(srcItem);
                destItem.getParent().getChildren().add(destIdx + 1, srcItem);
            }
        }
        this.getSelectionModel().select(selectSrc ? srcItem : destItem);
    }

    class DnDCell
    extends TreeTableCell<Task, String> {
        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.setText(item);
        }

        public DnDCell() {
            this.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    Task t = (Task)DnDCell.this.getTreeTableRow().getItem();
                    if (t == null) {
                        return;
                    }
                    Dragboard dragBoard = DnDCell.this.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                    ClipboardContent content = new ClipboardContent();
                    content.put((Object)DataFormat.PLAIN_TEXT, (Object)t.getId());
                    dragBoard.setContent((Map)content);
                    event.consume();
                }
            });
            this.setOnDragDone((EventHandler)new EventHandler<DragEvent>(){

                public void handle(DragEvent dragEvent) {
                    dragEvent.consume();
                }
            });
            this.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

                public void handle(DragEvent dragEvent) {
                    Task srcTask = BackupTreeTable.this.mapId.get(dragEvent.getDragboard().getString());
                    Task destTask = (Task)DnDCell.this.getTreeTableRow().getItem();
                    boolean isSrcGroup = srcTask instanceof GroupTask;
                    boolean isTargetGroup = destTask instanceof GroupTask;
                    if (isSrcGroup && isTargetGroup) {
                        if (srcTask == destTask) {
                            dragEvent.acceptTransferModes(TransferMode.NONE);
                        } else {
                            int destIdx;
                            int srcIdx = BackupTreeTable.this.rootElement.getGroups().indexOf(srcTask);
                            if (srcIdx == (destIdx = BackupTreeTable.this.rootElement.getGroups().indexOf(destTask)) + 1) {
                                dragEvent.acceptTransferModes(TransferMode.NONE);
                            } else {
                                dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                            }
                        }
                    } else if (isSrcGroup && !isTargetGroup) {
                        dragEvent.acceptTransferModes(TransferMode.NONE);
                    } else if (!isSrcGroup && isTargetGroup) {
                        if (srcTask.getParent() == destTask) {
                            if (srcTask.getParent().getTasks().get(0) == srcTask) {
                                dragEvent.acceptTransferModes(TransferMode.NONE);
                            } else {
                                dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                            }
                        } else {
                            dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                        }
                    } else if (srcTask == destTask) {
                        dragEvent.acceptTransferModes(TransferMode.NONE);
                    } else if (srcTask.getParent() != destTask.getParent()) {
                        dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                    } else {
                        int destIdx;
                        int srcIdx = srcTask.getParent().getTasks().indexOf(srcTask);
                        if (srcIdx == (destIdx = destTask.getParent().getTasks().indexOf(destTask)) + 1) {
                            dragEvent.acceptTransferModes(TransferMode.NONE);
                        } else {
                            dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                        }
                    }
                    dragEvent.consume();
                }
            });
            this.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

                public void handle(DragEvent dragEvent) {
                    Task srcTask = BackupTreeTable.this.mapId.get(dragEvent.getDragboard().getString());
                    Task destTask = (Task)DnDCell.this.getTreeTableRow().getItem();
                    BackupTreeTable.this.moveNode(srcTask, destTask, true);
                    dragEvent.consume();
                }
            });
        }
    }
}

