/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.backup;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import myencyclopedia.gui.backup.ProgressTable;
import myencyclopedia.gui.backup.Status;
import myencyclopedia.logic.backup.syncfolder.SyncResult;
import myencyclopedia.logic.backup.task.IGUIEventChannel;
import myencyclopedia.logic.backup.task.MonitorThread;
import myencyclopedia.logic.backup.task.Result;
import myencyclopedia.logic.backup.task.Task;
import myencyclopedia.logic.backup.task.execproc.ExecResult;

public class ProgressStage
extends Stage
implements IGUIEventChannel {
    private ProgressTable table;
    private TextArea messageArea;
    private Button btnClose;
    private List<Task> tasks;
    private MonitorThread monitorThread;
    private Map<Task, StringBuffer> taskToMessage;
    private Map<Task, SimpleObjectProperty> taskToStatusProperty;
    private Task activeTask = null;
    protected static ResourceBundle rb = ResourceBundle.getBundle("properties.gui-backup");
    public static final String CANCEL = rb.getString("CANCEL");
    public static final String CLOSE = rb.getString("CLOSE");

    public ProgressStage(List<Task> tasks) {
        this.tasks = tasks;
        this.initModality(Modality.APPLICATION_MODAL);
        this.taskToMessage = new HashMap<Task, StringBuffer>();
        this.taskToStatusProperty = new HashMap<Task, SimpleObjectProperty>();
        for (Task task : tasks) {
            this.taskToMessage.put(task, new StringBuffer(""));
            this.taskToStatusProperty.put(task, new SimpleObjectProperty((Object)Status.NOT_RUN));
        }
        this.initTable();
        FlowPane controlPane = new FlowPane();
        this.btnClose = new Button(CANCEL);
        this.btnClose.setOnAction(e -> this.confirmBeforeClose());
        controlPane.getChildren().add((Object)this.btnClose);
        this.messageArea = new TextArea();
        BorderPane pane = new BorderPane();
        pane.setTop((Node)this.table);
        pane.setCenter((Node)this.messageArea);
        pane.setBottom((Node)controlPane);
        this.setScene(new Scene((Parent)pane, 500.0, 600.0));
    }

    private void initTable() {
        this.table = new ProgressTable(this.taskToStatusProperty);
        this.table.getItems().addAll(this.tasks);
        this.table.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                ProgressStage.this.selectionChanged();
            }
        });
    }

    public void showIt() {
        this.monitorThread = new MonitorThread(this.tasks, (IGUIEventChannel)this, null);
        this.monitorThread.start();
        this.activeTask = this.tasks.get(0);
        this.show();
    }

    private void confirmBeforeClose() {
        if (this.btnClose.getText().equals(CANCEL)) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, rb.getString("ProgressStage.QuitRunning"), new ButtonType[0]);
            alert.showAndWait();
            if (alert.getResult() != ButtonType.OK) {
                return;
            }
            this.monitorThread.cancellAll();
            this.btnClose.setText(CLOSE);
        } else if (this.btnClose.getText().equals(CLOSE)) {
            this.hide();
        }
    }

    private void selectionChanged() {
        Task t = (Task)this.table.getSelectionModel().getSelectedItem();
        if (t == null) {
            return;
        }
        this.activeTask = t;
        StringBuffer message = this.taskToMessage.get(this.activeTask);
        this.messageArea.setText(message.toString());
        this.messageArea.setScrollTop(Double.MAX_VALUE);
    }

    public void dispatch(final Task task, IGUIEventChannel.TaskEvent event, Result payload) {
        SimpleObjectProperty prop = this.taskToStatusProperty.get(task);
        switch (event) {
            case START: {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ProgressStage.this.setTitle(rb.getString("ProgressStage.Title.Running") + task.getName());
                    }
                });
                prop.setValue((Object)Status.RUNNING);
                return;
            }
            case FAIL: {
                prop.setValue((Object)Status.FAIL);
                return;
            }
            case FINISHED: {
                prop = this.taskToStatusProperty.get(task);
                prop.setValue((Object)Status.SUCCESS);
                return;
            }
            case INTERRUPTED: {
                prop.setValue((Object)Status.CANCELLED);
                return;
            }
            case MESSAGE: {
                final StringBuffer buffer = this.taskToMessage.get(task);
                String newStr = null;
                if (payload instanceof SyncResult) {
                    SyncResult syncPayload = (SyncResult)payload;
                    newStr = syncPayload.getFileAffected() + " " + (syncPayload.isSuccess() ? "" : "FAILED") + " " + syncPayload.getMessage();
                } else if (payload instanceof ExecResult) {
                    newStr = ((ExecResult)payload).getOneLine();
                    ExecResult.OutputType outputType = ((ExecResult)payload).getType();
                    if (outputType == ExecResult.OutputType.EXIT_CODE) {
                        newStr = "[exit  ]" + newStr;
                    } else if (outputType == ExecResult.OutputType.STDOUT) {
                        newStr = "[stdout]" + newStr;
                    } else if (outputType == ExecResult.OutputType.STDERR) {
                        newStr = "[stderr]" + newStr;
                    } else if (outputType == ExecResult.OutputType.EXCEPTION) {
                        newStr = "[except]" + newStr;
                    }
                } else {
                    newStr = payload.toString();
                }
                buffer.append(newStr).append("\n");
                if (task == this.activeTask) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ProgressStage.this.messageArea.setText(buffer.toString());
                            ProgressStage.this.messageArea.setScrollTop(Double.MAX_VALUE);
                        }
                    });
                }
                return;
            }
        }
    }

    public void dispatch(final IGUIEventChannel.GlobalEvent event) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                switch (event) {
                    case START: {
                        break;
                    }
                    case FINISH: {
                        ProgressStage.this.btnClose.setText(CLOSE);
                        ProgressStage.this.setTitle(rb.getString("ProgressStage.Title.Finished"));
                    }
                }
            }
        });
    }
}

