/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.backup;

import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import myencyclopedia.common.gui.TableRetainFixedColumnResizePolicy;
import myencyclopedia.logic.backup.task.Task;

public class ProgressTable
extends TableView<Task> {
    protected static ResourceBundle rb = ResourceBundle.getBundle("properties.gui-backup");

    public ProgressTable(final Map<Task, SimpleObjectProperty> map) {
        TableColumn colStatus = new TableColumn(rb.getString("COLUMN_STATUS"));
        colStatus.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Task, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Task, String> param) {
                Task t = (Task)param.getValue();
                return (ObservableValue)map.get(t);
            }
        });
        TableColumn colName = new TableColumn(rb.getString("COLUMN_NAME"));
        colName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        TableColumn colType = new TableColumn(rb.getString("COLUMN_TYPE"));
        colType.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Task, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Task, String> param) {
                Task t = (Task)param.getValue();
                return new ReadOnlyStringWrapper(rb.getString(t.getClass().getSimpleName()));
            }
        });
        TableColumn colSrc = new TableColumn(rb.getString("COLUMN_SOURCE"));
        colSrc.setCellValueFactory((Callback)new PropertyValueFactory("source"));
        TableColumn colDest = new TableColumn(rb.getString("COLUMN_DEST"));
        colDest.setCellValueFactory((Callback)new PropertyValueFactory("destination"));
        this.getColumns().addAll((Object[])new TableColumn[]{colStatus, colName, colType, colSrc, colDest});
        this.setColumnResizePolicy((Callback)new TableRetainFixedColumnResizePolicy());
        this.setSortPolicy((Callback)new Callback<TableView<Task>, Boolean>(){

            public Boolean call(TableView param) {
                return false;
            }
        });
        this.setEditable(false);
    }
}

