/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.backup;

import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import myencyclopedia.common.gui.InputGridPane;
import myencyclopedia.gui.backup.CopyFolderTaskOptionPane;
import myencyclopedia.gui.backup.CpZippedFolderTaskOptionPane;
import myencyclopedia.gui.backup.RuntimeExecTaskOptionPane;
import myencyclopedia.gui.backup.SyncFolderTaskOptionPane;
import myencyclopedia.gui.backup.TaskOptionPane;
import myencyclopedia.logic.backup.task.CopyFolderTask;
import myencyclopedia.logic.backup.task.CpZippedFolderTask;
import myencyclopedia.logic.backup.task.GroupTask;
import myencyclopedia.logic.backup.task.RuntimeExecTask;
import myencyclopedia.logic.backup.task.SyncFolderTask;
import myencyclopedia.logic.backup.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStage
extends Stage {
    private Button okBtn;
    private Button cancelBtn;
    private InputGridPane inputPane;
    private ComboBox comboBox;
    private Task task;
    private TaskOptionPane optionPane;
    private VBox box;
    static final Logger logger = LoggerFactory.getLogger(TaskStage.class);
    private boolean isOkPressed = false;
    protected static ResourceBundle rb = ResourceBundle.getBundle("properties.gui-backup");
    public static final String TASK_COPY_FOLDER = rb.getString("CopyFolderTask");
    public static final String TASK_CP_ZIPPED = rb.getString("CpZippedFolderTask");
    public static final String TASK_SYNC_FOLDER = rb.getString("SyncFolderTask");
    public static final String TASK_RUNTIME_EXEC = rb.getString("RuntimeExecTask");
    public static final String LABEL_NAME = rb.getString("NewTaskStage.Name");
    public static final String LABEL_SOURCE = rb.getString("NewTaskStage.SrcFolder");
    public static final String LABEL_DEST = rb.getString("NewTaskStage.DestinationFolder");
    public static final String LABEL_PARAM = rb.getString("NewTaskStage.Params");
    private SyncFolderTaskOptionPane optionSync;
    private CpZippedFolderTaskOptionPane optionCpZipped;
    private CopyFolderTaskOptionPane optionCopy;
    private RuntimeExecTaskOptionPane optionExec;
    VBox emptyBox = new VBox();

    public TaskStage() {
        this.initModality(Modality.APPLICATION_MODAL);
        this.optionSync = new SyncFolderTaskOptionPane();
        this.optionCpZipped = new CpZippedFolderTaskOptionPane();
        this.optionCopy = new CopyFolderTaskOptionPane();
        this.optionExec = new RuntimeExecTaskOptionPane();
        this.okBtn = new Button(rb.getString("OK"));
        this.okBtn.setOnAction(e -> {
            this.isOkPressed = true;
            this.hide();
        });
        this.okBtn.setDefaultButton(true);
        this.cancelBtn = new Button(rb.getString("CANCEL"));
        this.cancelBtn.setOnAction(e -> {
            this.isOkPressed = false;
            this.hide();
        });
        this.cancelBtn.setCancelButton(true);
        HBox buttonPane = new HBox();
        buttonPane.getChildren().addAll((Object[])new Node[]{this.okBtn, this.cancelBtn});
        this.comboBox = new ComboBox();
        this.comboBox.getItems().addAll(new Object[]{TASK_SYNC_FOLDER, TASK_CP_ZIPPED, TASK_COPY_FOLDER, TASK_RUNTIME_EXEC});
        HBox comboBoxBox = new HBox();
        comboBoxBox.setPadding(new Insets(3.0));
        comboBoxBox.getChildren().addAll((Object[])new Node[]{new Label(rb.getString("NewTaskStage.SelectCategory")), this.comboBox});
        this.comboBox.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue ov, String oldStr, String newStr) {
                if (newStr.equals(TASK_RUNTIME_EXEC)) {
                    TaskStage.this.optionPane = TaskStage.this.optionExec;
                    TaskStage.this.inputPane.setDisabled(LABEL_SOURCE, true);
                    TaskStage.this.inputPane.setDisabled(LABEL_DEST, true);
                } else if (newStr.equals(TASK_SYNC_FOLDER)) {
                    TaskStage.this.optionPane = TaskStage.this.optionSync;
                    TaskStage.this.inputPane.setDisabled(LABEL_SOURCE, false);
                    TaskStage.this.inputPane.setDisabled(LABEL_DEST, false);
                } else if (newStr.equals(TASK_CP_ZIPPED)) {
                    TaskStage.this.optionPane = TaskStage.this.optionCpZipped;
                    TaskStage.this.inputPane.setDisabled(LABEL_SOURCE, false);
                    TaskStage.this.inputPane.setDisabled(LABEL_DEST, false);
                } else if (newStr.equals(TASK_COPY_FOLDER)) {
                    TaskStage.this.optionPane = TaskStage.this.optionCopy;
                    TaskStage.this.inputPane.setDisabled(LABEL_SOURCE, false);
                    TaskStage.this.inputPane.setDisabled(LABEL_DEST, false);
                } else {
                    TaskStage.this.inputPane.setDisabled(LABEL_SOURCE, true);
                    TaskStage.this.inputPane.setDisabled(LABEL_DEST, true);
                }
                TaskStage.this.updateOptionPane();
            }
        });
        this.inputPane = new InputGridPane();
        this.inputPane.nextText(LABEL_NAME, rb.getString("NewTaskStage.NewName"));
        this.inputPane.nextDir(LABEL_SOURCE, null).setPrefColumnCount(20);
        this.inputPane.nextDir(LABEL_DEST, null).setPrefColumnCount(20);
        this.inputPane.setPadding(new Insets(4.0));
        this.box = new VBox();
        this.box.getChildren().add((Object)this.inputPane);
        this.box.getChildren().add((Object)this.emptyBox);
        BorderPane pane = new BorderPane();
        pane.setTop((Node)comboBoxBox);
        pane.setCenter((Node)this.box);
        pane.setBottom((Node)buttonPane);
        Scene scene = new Scene((Parent)pane);
        this.setScene(scene);
        this.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                TaskStage.this.isOkPressed = false;
            }
        });
        this.sizeToScene();
    }

    public Task getCreatedTask() {
        return this.task;
    }

    private void updateOptionPane() {
        this.box.getChildren().remove(1);
        this.box.getChildren().add((Object)((Node)this.optionPane));
    }

    private void createTask() {
        String type = (String)this.comboBox.getSelectionModel().getSelectedItem();
        if (type == null) {
            this.task = null;
            return;
        }
        if (type.equals(TASK_SYNC_FOLDER)) {
            this.task = new SyncFolderTask();
        } else if (type.equals(TASK_RUNTIME_EXEC)) {
            this.task = new RuntimeExecTask();
        } else if (type.equals(TASK_CP_ZIPPED)) {
            this.task = new CpZippedFolderTask();
        } else if (type.equals(TASK_COPY_FOLDER)) {
            this.task = new CopyFolderTask();
        }
        this.task = this.updateTask();
    }

    private Task updateTask() {
        Class selectedCls = this.getTaskClass();
        Task ret = this.task;
        if (!this.task.getClass().equals(selectedCls)) {
            try {
                ret = (Task)selectedCls.newInstance();
                ret.setId(this.task.getId());
                ret.setIsSelected(this.task.getIsSelected());
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
                return this.task;
            }
            GroupTask group = this.task.getParent();
            int index = group.getTasks().indexOf(this.task);
            group.getTasks().remove(index);
            group.addTask(index, ret);
        }
        ret.setName(this.inputPane.getValueFor(LABEL_NAME));
        ret.setSource(this.inputPane.getValueFor(LABEL_SOURCE));
        ret.setDestination(this.inputPane.getValueFor(LABEL_DEST));
        this.optionPane.contructParam(ret);
        return ret;
    }

    public Task showTask(Task task) {
        this.task = task;
        task.parseParam();
        if (SyncFolderTask.class.equals(task.getClass())) {
            this.comboBox.getSelectionModel().select((Object)TASK_SYNC_FOLDER);
            this.optionPane = this.optionSync;
        } else if (RuntimeExecTask.class.equals(task.getClass())) {
            this.comboBox.getSelectionModel().select((Object)TASK_RUNTIME_EXEC);
            this.optionPane = this.optionExec;
        } else if (CpZippedFolderTask.class.equals(task.getClass())) {
            this.comboBox.getSelectionModel().select((Object)TASK_CP_ZIPPED);
            this.optionPane = this.optionCpZipped;
        } else if (CopyFolderTask.class.equals(task.getClass())) {
            this.comboBox.getSelectionModel().select((Object)TASK_COPY_FOLDER);
            this.optionPane = this.optionCopy;
        }
        this.optionPane.bind(task);
        this.updateOptionPane();
        this.inputPane.setValueFor(LABEL_NAME, task.getName());
        this.inputPane.setValueFor(LABEL_SOURCE, task.getSource());
        this.inputPane.setValueFor(LABEL_DEST, task.getDestination());
        this.sizeToScene();
        this.setTitle(String.format(rb.getString("NewTaskStage.TaskTitle"), task.getName()));
        this.showAndWait();
        if (this.isOkPressed) {
            return this.updateTask();
        }
        return task;
    }

    public Task showTask() {
        this.task = null;
        this.comboBox.getSelectionModel().select(0);
        this.inputPane.setValueFor(LABEL_NAME, rb.getString("NewTaskStage.NewName"));
        this.inputPane.setValueFor(LABEL_SOURCE, "");
        this.inputPane.setValueFor(LABEL_DEST, "");
        this.setTitle(rb.getString("NewTaskStage.NewTask"));
        this.showAndWait();
        if (this.isOkPressed) {
            this.createTask();
            return this.task;
        }
        return null;
    }

    private Class getTaskClass() {
        String type = (String)this.comboBox.getSelectionModel().getSelectedItem();
        if (type.equals(TASK_COPY_FOLDER)) {
            return CopyFolderTask.class;
        }
        if (type.equals(TASK_CP_ZIPPED)) {
            return CpZippedFolderTask.class;
        }
        if (type.equals(TASK_RUNTIME_EXEC)) {
            return RuntimeExecTask.class;
        }
        if (type.equals(TASK_SYNC_FOLDER)) {
            return SyncFolderTask.class;
        }
        return null;
    }
}

