/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.hibernate;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import myencyclopedia.model.hbn.SchemaUtil;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;

public class HibernateUtil {
    private static final String MODE_CREATE = "create";
    private static final String MODE_UPDATE = "update";
    private static final String MODE_VALIDATE = "validate";

    private static Configuration createConfiguration(String type, String xmlFile, String dbURL, Class[] clsArray) {
        return HibernateUtil.createConfiguration(type, xmlFile, dbURL, clsArray, null);
    }

    private static Configuration createConfiguration(String type, String xmlFile, String dbURL, Class[] clsArray, Map<String, Object> propertyMap) {
        AnnotationConfiguration config = new AnnotationConfiguration();
        for (Class cls : SchemaUtil.CORE_CLASSES) {
            config.addAnnotatedClass(cls);
        }
        if (clsArray != null) {
            for (Class cls : clsArray) {
                config.addAnnotatedClass(cls);
            }
        }
        if (type != null) {
            config.setProperty("hibernate.hbm2ddl.auto", type);
        }
        config.configure(xmlFile);
        if (dbURL != null) {
            config.setProperty("hibernate.connection.url", dbURL);
        }
        if (propertyMap != null) {
            for (Map.Entry entry : propertyMap.entrySet()) {
                config.getProperties().put(entry.getKey(), entry.getValue());
            }
        }
        return config;
    }

    private static SessionFactory buildSessionFactory(String type, String xmlFile, String dbURL, Class[] clsArray, Map<String, Object> propertyMap) throws HibernateException, SchemaUtil.SchemaUnmatchedException {
        Configuration config = null;
        config = HibernateUtil.createConfiguration(type, xmlFile, dbURL, clsArray, propertyMap);
        SessionFactory sf = config.buildSessionFactory();
        if (MODE_UPDATE.equals(type)) {
            SchemaUtil.updateVersion((Class[])clsArray, (SessionFactory)sf);
        } else if (MODE_VALIDATE.equals(type)) {
            SchemaUtil.verifyDB((Class[])clsArray, (SessionFactory)sf);
        }
        return sf;
    }

    public static SessionFactory getSessionFactory(String xmlFile, Class[] classArray) throws HibernateException, SchemaUtil.SchemaUnmatchedException {
        SessionFactory sessionFactory = HibernateUtil.buildSessionFactory(MODE_CREATE, xmlFile, null, classArray, null);
        return sessionFactory;
    }

    public static SessionFactory getExistingDBSessionFactory(String xmlFile, Class[] classArray) throws HibernateException, SchemaUtil.SchemaUnmatchedException {
        SessionFactory sessionFactory = HibernateUtil.buildSessionFactory(MODE_VALIDATE, xmlFile, null, classArray, null);
        return sessionFactory;
    }

    public static SessionFactory connectSessionFactory(String xmlFile, String jdbc, Class[] classArray) throws HibernateException, SchemaUtil.SchemaUnmatchedException {
        SessionFactory sessionFactory = HibernateUtil.buildSessionFactory(null, xmlFile, jdbc, classArray, null);
        return sessionFactory;
    }

    public static SessionFactory getSessionFactory(String xmlFile, String dbURL, Class[] classArray, Map<String, Object> propertyMap) throws HibernateException, SchemaUtil.SchemaUnmatchedException {
        SessionFactory sessionFactory = HibernateUtil.buildSessionFactory(MODE_CREATE, xmlFile, "jdbc:h2:file:" + dbURL, classArray, propertyMap);
        SchemaUtil.persistVersion((Class[])classArray, (SessionFactory)sessionFactory);
        return sessionFactory;
    }

    public static SessionFactory getExistingOrCreateDBSessionFactory(String xmlFile, String dbURL, Class[] classArray, Map<String, Object> propertyMap) throws HibernateException, SchemaUtil.SchemaUnmatchedException {
        Path realDBFile = Paths.get(dbURL + ".mv.db", new String[0]);
        if (!Files.exists(realDBFile, new LinkOption[0])) {
            return HibernateUtil.getSessionFactory(xmlFile, dbURL, classArray, propertyMap);
        }
        SessionFactory sessionFactory = HibernateUtil.buildSessionFactory(MODE_VALIDATE, xmlFile, "jdbc:h2:file:" + dbURL, classArray, propertyMap);
        return sessionFactory;
    }

    public static SessionFactory getExistingDBSessionFactory(String xmlFile, String dbURL, Class[] classArray) throws HibernateException, SchemaUtil.SchemaUnmatchedException {
        SessionFactory sessionFactory = HibernateUtil.buildSessionFactory(MODE_VALIDATE, xmlFile, "jdbc:h2:file:" + dbURL, classArray, null);
        return sessionFactory;
    }

    public static SessionFactory getUpdatedDBSessionFactory(String xmlFile, String dbURL, Class[] classArray, Map<String, Object> propertyMap) throws HibernateException, SchemaUtil.SchemaUnmatchedException {
        System.out.println("Update DB ! " + dbURL);
        SessionFactory sessionFactory = HibernateUtil.buildSessionFactory(MODE_UPDATE, xmlFile, "jdbc:h2:file:" + dbURL, classArray, propertyMap);
        return sessionFactory;
    }
}

