/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.model.common.entity;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import myencyclopedia.model.hbn.HBAbstractEntity;
import myencyclopedia.model.hbn.HBRelation;
import myencyclopedia.model.hbn.PropertyField;
import myencyclopedia.model.hbn.RelationField;
import org.hibernate.annotations.Type;

@Entity
@Table(name="files")
public class FileObject
extends HBAbstractEntity
implements Serializable {
    public static final int _version = 1;
    public static final String P_NAME = "name";
    public static final String P_RELATIVE_PATH = "relative_path";
    public static final String P_MD5 = "hash_md5";
    public static final String P_ED2K = "hash_ed2k";
    public static final String P_SHA1 = "hash_sha1";
    public static final String P_FILE_SIZE = "file_size";
    public static final String P_DATE_MODIFIED = "date_modified";
    public static final String P_DATE_CREATED = "date_created";
    public static final String P_DATE_ACCESSED = "date_accessed";
    public static final String P_IS_DIR = "is_dir";
    public static final String P_FILEFORMAT_ID = "file_format_id";
    public static final String R_PARENT = "parent";
    public static final String R_CONTAINER = "container";
    @RelationField(name="parent")
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn
    protected HBRelation parent;
    @RelationField(name="container")
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn
    protected HBRelation container;
    @PropertyField(name="name")
    @Column(name="name", nullable=false)
    private String fileName;
    @PropertyField(name="relative_path")
    @Column(name="relative_path", length=1000)
    private String relativePath;
    @PropertyField(name="hash_md5")
    @Column(name="hash_md5")
    private String md5;
    @PropertyField(name="hash_sha1")
    @Column(name="hash_sha1")
    private String sha1;
    @PropertyField(name="hash_ed2k")
    @Column(name="hash_ed2k")
    private String hashEd2k;
    @PropertyField(name="file_size")
    @Column(name="file_size")
    private Long fileSize = 0L;
    @PropertyField(name="date_modified")
    @Column(name="date_modified")
    private Date dateModifed;
    @PropertyField(name="date_accessed")
    @Column(name="date_accessed")
    private Date dateAccessed;
    @PropertyField(name="date_created")
    @Column(name="date_created")
    private Date dateCreated;
    @Column(name="file_format_id")
    private Integer fileFormatId;
    @PropertyField(name="is_dir")
    @Type(type="true_false")
    @Column(name="is_dir")
    private Boolean isDir;

    public HBRelation getParent() {
        return this.parent;
    }

    public void setParent(HBRelation parent) {
        this.parent = parent;
    }

    public Date getDateAccessed() {
        return this.dateAccessed;
    }

    public void setDateAccessed(Date dateAccessed) {
        this.dateAccessed = dateAccessed;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateModifed() {
        return this.dateModifed;
    }

    public void setDateModifed(Date dateModifed) {
        this.dateModifed = dateModifed;
    }

    public Integer getFileFormatId() {
        return this.fileFormatId;
    }

    public void setFileFormatId(Integer fileFormatId) {
        this.fileFormatId = fileFormatId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public void addFileSize(Long fileSize) {
        FileObject fileObject = this;
        fileObject.fileSize = fileObject.fileSize + fileSize;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public String getHashEd2k() {
        return this.hashEd2k;
    }

    public void setHashEd2k(String hashEd2k) {
        this.hashEd2k = hashEd2k;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public Boolean getIsDir() {
        return this.isDir;
    }

    public void setIsDir(Boolean isDir) {
        this.isDir = isDir;
    }

    public String toString() {
        if (this.relativePath == null || this.relativePath.isEmpty()) {
            return this.fileName;
        }
        return this.relativePath + File.separator + this.fileName;
    }
}

