/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.model.common.usertype;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import myencyclopedia.model.common.IntCustomClass;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.type.IntegerType;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegerUserType
implements UserType,
ParameterizedType {
    public Class cls;
    private static final Logger logger = LoggerFactory.getLogger(IntegerUserType.class);

    public int[] sqlTypes() {
        return new int[]{IntegerType.INSTANCE.sqlType()};
    }

    public Class returnedClass() {
        return this.cls;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor si, Object o) throws HibernateException, SQLException {
        Integer value = rs.getInt(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        return IntCustomClass.fromIntValue((Integer)value, (Class)this.cls);
    }

    public void nullSafeSet(PreparedStatement ps, Object value, int i, SessionImplementor si) throws HibernateException, SQLException {
        if (value == null) {
            ps.setNull(i, IntegerType.INSTANCE.sqlType());
        } else {
            IntCustomClass lang = (IntCustomClass)value;
            ps.setInt(i, lang.getIntValue());
        }
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public int hashCode(Object o) throws HibernateException {
        return o.hashCode();
    }

    public Object deepCopy(Object o) throws HibernateException {
        return o;
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object o) throws HibernateException {
        return (Serializable)o;
    }

    public Object assemble(Serializable srlzbl, Object o) throws HibernateException {
        return srlzbl;
    }

    public Object replace(Object o, Object o1, Object o2) throws HibernateException {
        return o;
    }

    public void setParameterValues(Properties parameters) {
        try {
            this.cls = Class.forName(parameters.getProperty("cls"));
        }
        catch (ClassNotFoundException ex) {
            logger.error("", (Throwable)ex);
        }
    }
}

