/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.model.ebook;

import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import myencyclopedia.model.Entity;
import myencyclopedia.model.common.Currency;
import myencyclopedia.model.common.Language;
import myencyclopedia.model.common.YearMonthDay;
import myencyclopedia.model.common.entity.Tag;
import myencyclopedia.model.common.entity.Taggable;
import myencyclopedia.model.ebook.Discipline;
import myencyclopedia.model.ebook.EbookAuthor;
import myencyclopedia.model.ebook.EbookFileInfo;
import myencyclopedia.model.ebook.ISBN;
import myencyclopedia.model.ebook.MyComment;
import myencyclopedia.model.ebook.Publisher;
import myencyclopedia.model.ebook.Series;
import myencyclopedia.model.ebook.TitleI18N;
import myencyclopedia.model.hbn.HBAbstractEntity;
import myencyclopedia.model.hbn.HBRelation;
import myencyclopedia.model.hbn.HBRelationCollection;
import myencyclopedia.model.hbn.PropertyField;
import myencyclopedia.model.hbn.RelationField;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@javax.persistence.Entity
@Table(name="ebook")
public class Ebook
extends HBAbstractEntity
implements Serializable,
Taggable {
    public static final String P_EDITION = "edition";
    public static final String P_PAGES = "pages";
    public static final String P_IS_TRANSLATED = "is_translated";
    public static final String P_DESCRIPTION = "description";
    public static final String P_DISCIPLINE = "discipline";
    public static final String P_PRICE = "price";
    public static final String P_PUBLISH_DATE = "published_date";
    public static final String P_CURRENCY = "currency";
    public static final String P_TITLE_I18N = "titlei18n";
    public static final String P_LANGUAGES = "languages";
    public static final String P_ISBN = "isbn";
    public static final String P_FAVOURITE = "favourite";
    public static final String P_IS_HIDDEN = "is_hidden";
    public static final String P_FILE_EXT_INFO = "extinfo";
    public static final String R_MY_COMENT = "mycomment";
    public static final String R_AUTHORS = "authors";
    public static final String R_ATTACHMENTS = "attachments";
    public static final String R_IMAGES = "images";
    public static final String R_FILE_INFO = "file_info";
    public static final String R_SERIES = "series";
    public static final String R_PUBLISHERS = "publishers";
    public static final String R_TAGS = "tags";
    @PropertyField(name="edition")
    @Column(name="edition", nullable=true)
    private Byte edition;
    @PropertyField(name="pages")
    @Column(name="pages", nullable=true)
    private Integer pages;
    @PropertyField(name="is_translated")
    @Column(name="is_translated", nullable=true)
    @Type(type="true_false")
    private Boolean is_translated;
    @PropertyField(name="description")
    @Column(name="description", nullable=false)
    private String description;
    @RelationField(name="mycomment")
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="mycomment")
    protected HBRelation<MyComment> mycomments;
    @PropertyField(name="discipline")
    @Column(name="discipline", columnDefinition="int", nullable=false)
    @Type(type="myencyclopedia.model.common.usertype.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="myencyclopedia.model.ebook.Discipline"), @Parameter(name="identifierMethod", value="toInt"), @Parameter(name="valueOfMethod", value="fromInt")})
    private Discipline discipline;
    @PropertyField(name="published_date")
    @Column(name="published_date")
    @Type(type="myencyclopedia.model.common.usertype.YearMonthDayUserType")
    private YearMonthDay published_date;
    @PropertyField(name="favourite")
    @Column(name="favourite")
    protected Integer is_favourite;
    @PropertyField(name="is_hidden")
    @Column(name="is_hidden")
    protected Boolean is_hidden;
    @PropertyField(name="extinfo")
    @Column(name="extinfo")
    protected String extentions;
    @PropertyField(name="currency")
    @Column(name="currency")
    @Type(type="myencyclopedia.model.common.usertype.IntegerUserType", parameters={@Parameter(name="cls", value="myencyclopedia.model.common.Currency")})
    private Currency currency;
    @PropertyField(name="titlei18n")
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="titlei18n", joinColumns={@JoinColumn(name="titlei18n_id")})
    @OrderColumn(name="titlei18nlist_order")
    protected List<TitleI18N> titles;
    @PropertyField(name="isbn")
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="isbn", joinColumns={@JoinColumn(name="isbn_id")})
    @OrderColumn(name="isbnlist_order")
    protected List<ISBN> isbns;
    @PropertyField(name="languages")
    @ElementCollection(fetch=FetchType.EAGER)
    @Column(name="languages")
    @Type(type="myencyclopedia.model.common.usertype.IntegerUserType", parameters={@Parameter(name="cls", value="myencyclopedia.model.common.Language")})
    @OrderColumn
    protected List<Language> languages;
    @RelationField(name="file_info")
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="file_info")
    protected HBRelationCollection<EbookFileInfo> fileinfos;
    @RelationField(name="authors")
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="authors")
    protected HBRelationCollection<EbookAuthor> authors;
    @RelationField(name="images")
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="images")
    protected HBRelationCollection images;
    @RelationField(name="attachments")
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="attachments")
    protected HBRelationCollection attachments;
    @RelationField(name="series")
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="series")
    protected HBRelationCollection<Series> series;
    @RelationField(name="tags")
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="RC_Tags")
    protected HBRelationCollection<Tag> tags;
    @RelationField(name="publishers")
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="publishers")
    protected HBRelationCollection<Publisher> publishers;

    public EbookFileInfo getDefaultEbookFileInfo() {
        if (this.fileinfos.getTarget() != null) {
            return null;
        }
        return ((EbookFileInfo[])this.fileinfos.getTarget())[0];
    }

    public TitleI18N getDefaultTitleI18n() {
        return this.titles.get(0);
    }

    public List<TitleI18N> getTitleI18nList() {
        return this.titles;
    }

    public Byte getEdition() {
        return this.edition;
    }

    public void setEdition(Byte edition) {
        this.edition = edition;
    }

    public Integer getPages() {
        return this.pages;
    }

    public void setPages(Integer pages) {
        this.pages = pages;
    }

    public Boolean isIsTranslated() {
        return this.is_translated;
    }

    public void setIsTranslated(Boolean isTranslated) {
        this.is_translated = isTranslated;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Discipline getDiscipline() {
        return this.discipline;
    }

    public void setDiscipline(Discipline discipline) {
        this.discipline = discipline;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public String getFileExtInfo() {
        return this.extentions;
    }

    public void setFileExtInfo(String propertyExt) {
        this.extentions = propertyExt;
    }

    public boolean isFavourite() {
        return this.is_favourite != null;
    }

    public List<ISBN> getIsbnList() {
        return this.isbns;
    }

    public void setIsbnList(List<ISBN> isbnList) {
        this.isbns = isbnList;
    }

    public List<Language> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<Language> languages) {
        this.languages = languages;
    }

    public String toString() {
        TitleI18N i18n = this.titles.get(0);
        return i18n.getTitle();
    }

    public String toFullInfo() {
        TitleI18N i18n = this.titles.get(0);
        return i18n.getTitle() + (i18n.getSubtitle() == null || i18n.getSubtitle().isEmpty() ? "" : " -- " + i18n.getSubtitle()) + (this.edition != null && this.edition != 0 ? " [ed: " + this.edition + "]" : "") + (i18n.getVolumn() == null || i18n.getVolumn().isEmpty() ? "" : " [vol:" + i18n.getVolumn() + "]");
    }

    public Tag[] getTags() {
        if (this.tags == null) {
            return Taggable.EMPTY_TAGS;
        }
        Entity[] entities = this.tags.getTarget();
        Tag[] ret = new Tag[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            ret[i] = (Tag)entities[i];
        }
        return ret;
    }
}

