/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.progress.filewalker;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Objects;
import myencyclopedia.common.progress.Logic;
import myencyclopedia.common.progress.filewalker.FileLogicEvent;
import myencyclopedia.common.progress.filewalker.FileTreeWalker;
import myencyclopedia.common.utils.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWalkerLogic
extends Logic {
    protected Path start;
    protected FileVisitor<? super Path> visitor;
    protected FileTreeWalker walker;
    protected FileTreeWalker.Event ev;
    protected Tuple<FileTreeWalker.EventType, Path> tuple;
    protected FileLogicEvent startStepEvent = new FileLogicEvent("StartOneStep");
    private static final Logger logger = LoggerFactory.getLogger(FileWalkerLogic.class);

    public FileWalkerLogic(Path start, FileVisitor<? super Path> visitor) {
        this.walker = new FileTreeWalker(EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE);
        this.visitor = visitor;
        this.start = start;
    }

    protected FileWalkerLogic() {
    }

    @Override
    public boolean doPrepare() {
        this.ev = this.walker.walk(this.start);
        return true;
    }

    @Override
    public boolean hasNextStep() {
        if (this.ev != null) {
            this.tuple = new Tuple<FileTreeWalker.EventType, Path>(this.ev.type(), this.ev.file());
            return true;
        }
        return false;
    }

    @Override
    public void doStep() {
        FileVisitResult result = null;
        try {
            switch (this.ev.type()) {
                case ENTRY: {
                    IOException ioe = this.ev.ioeException();
                    if (ioe == null) {
                        assert (this.ev.attributes() != null);
                        result = this.visitor.visitFile(this.ev.file(), this.ev.attributes());
                        break;
                    }
                    result = this.visitor.visitFileFailed(this.ev.file(), ioe);
                    break;
                }
                case START_DIRECTORY: {
                    result = this.visitor.preVisitDirectory(this.ev.file(), this.ev.attributes());
                    if (result == FileVisitResult.SKIP_SUBTREE || result == FileVisitResult.SKIP_SIBLINGS) {
                        this.walker.pop();
                    }
                    break;
                }
                case END_DIRECTORY: {
                    result = this.visitor.postVisitDirectory(this.ev.file(), this.ev.ioeException());
                    if (result == FileVisitResult.SKIP_SIBLINGS) {
                        result = FileVisitResult.CONTINUE;
                    }
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Should not get here");
                }
            }
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
        if (Objects.requireNonNull(result) != FileVisitResult.CONTINUE) {
            if (result == FileVisitResult.TERMINATE) {
                this.ev = null;
                return;
            }
            if (result == FileVisitResult.SKIP_SIBLINGS) {
                this.walker.skipRemainingSiblings();
            }
        }
        this.ev = this.walker.next();
    }

    @Override
    public void doCleanUp() {
        this.walker.close();
    }

    @Override
    public boolean isSuccess() {
        return true;
    }

    @Override
    public boolean isProgressSupported() {
        return false;
    }

    @Override
    public int getProgressPercent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected FileLogicEvent constructStartOneStepEvent() {
        if (this.tuple != null) {
            this.startStepEvent.setValue(((Path)this.tuple.y).toString());
        }
        return this.startStepEvent;
    }

    @Override
    protected FileLogicEvent constructFinishOneStepEvent() {
        return this.startStepEvent;
    }

    @Override
    public boolean onException(Exception ex) {
        logger.error("", (Throwable)ex);
        return true;
    }
}

