/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.utils;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Base64;
import javax.crypto.Cipher;

public class CertUtil {
    private static String password = "123456";
    private static String alias = "myencyclopedia";
    public static final String KEY_STORE = "JKS";
    public static final String X509 = "X.509";

    public static byte[] encrypt(String str, InputStream keyStoreIS) throws Exception {
        byte[] data = str.getBytes();
        byte[] encodedData = CertUtil.encryptByPrivateKey(data, keyStoreIS, alias, password);
        return encodedData;
    }

    public static byte[] decrypt(byte[] encodedData, InputStream certIS) throws Exception {
        byte[] decodedData = CertUtil.decryptByPublicKey(encodedData, certIS);
        return decodedData;
    }

    private static Certificate getCertificate(InputStream certIS) throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance(X509);
        Certificate certificate = certificateFactory.generateCertificate(certIS);
        certIS.close();
        return certificate;
    }

    private static PublicKey getPublicKey(InputStream certIS) throws Exception {
        Certificate certificate = CertUtil.getCertificate(certIS);
        PublicKey key = certificate.getPublicKey();
        return key;
    }

    public static byte[] decryptByPublicKey(byte[] data, InputStream certIS) throws Exception {
        PublicKey publicKey = CertUtil.getPublicKey(certIS);
        Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
        cipher.init(2, publicKey);
        return cipher.doFinal(data);
    }

    public static byte[] encryptByPrivateKey(byte[] data, InputStream keyStoreIS, String alias, String password) throws Exception {
        PrivateKey privateKey = CertUtil.getPrivateKey(keyStoreIS, alias, password);
        Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
        cipher.init(1, privateKey);
        return cipher.doFinal(data);
    }

    private static PrivateKey getPrivateKey(InputStream keyStoreIS, String alias, String password) throws Exception {
        KeyStore ks = CertUtil.getKeyStore(keyStoreIS, password);
        PrivateKey key = (PrivateKey)ks.getKey(alias, password.toCharArray());
        return key;
    }

    private static KeyStore getKeyStore(InputStream keyStoreIS, String password) throws Exception {
        KeyStore ks = KeyStore.getInstance(KEY_STORE);
        ks.load(keyStoreIS, password.toCharArray());
        keyStoreIS.close();
        return ks;
    }

    public static void main(String[] args) throws Exception {
        String inputStr = "product:Datum;version:1.0;user:UserName;";
        InputStream keyStoreInputStream = CertUtil.class.getResourceAsStream("/me.keystore");
        InputStream certInputStream = CertUtil.class.getResourceAsStream("/me.cer");
        byte[] magic = CertUtil.encrypt(inputStr, keyStoreInputStream);
        String strMagic = Base64.getEncoder().encodeToString(magic);
        System.out.println(strMagic);
        magic = Base64.getDecoder().decode(strMagic);
        byte[] demagic = CertUtil.decrypt(magic, certInputStream);
        String outputStr = new String(demagic);
        if (!inputStr.equals(outputStr)) {
            System.out.println("Error");
        } else {
            System.out.println("Passed");
        }
    }
}

